/*
 * Decompiled with CFR 0.152.
 */
package org.atari.asma;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import org.atari.asma.ASMADatabase;
import org.atari.asma.ASMAHTMLExporter;
import org.atari.asma.ComposerList;
import org.atari.asma.FileInfoList;
import org.atari.asma.GroupList;
import org.atari.asma.HTMLWriter;
import org.atari.asma.STIL;
import org.atari.asma.demozoo.ASMAProductionList;
import org.atari.asma.demozoo.Demozoo;
import org.atari.asma.demozoo.model.Database;
import org.atari.asma.sap.ASAPFileLogic;
import org.atari.asma.util.FileUtility;
import org.atari.asma.util.MemoryUtility;
import org.atari.asma.util.MessageQueue;
import org.atari.asma.util.MessageQueueFactory;
import org.atari.asma.util.StringUtility;

public class ASMAExporter {
    public static void main(String[] args) {
        new ASMAExporter().run(args);
    }

    private ASMAExporter() {
    }

    private void exportJS(ASMADatabase asmaDatabase, File asmaDatabaseFile, MessageQueue messageQueue) {
        messageQueue.sendInfo("Exporting " + asmaDatabase.fileInfoList.getEntries().size() + " file infos to " + asmaDatabaseFile.getPath() + ".");
        Writer writer = null;
        try {
            try {
                writer = new FileWriter(asmaDatabaseFile, Charset.forName("UTF8"));
                asmaDatabase.write(writer);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        messageQueue.sendInfo("ASMA database exported as JS to " + asmaDatabaseFile.getAbsolutePath() + " with " + MemoryUtility.getRoundedMemorySize(asmaDatabaseFile.length()) + ".");
    }

    private void exportHTML(ASMADatabase asmaDatabase, Database database, File htmlFile, String basePath, MessageQueue messageQueue) {
        Writer writer = null;
        try {
            try {
                writer = new FileWriter(htmlFile, Charset.forName("UTF8"));
                HTMLWriter htmlWriter = new HTMLWriter(writer);
                ASMAHTMLExporter htmlExporter = new ASMAHTMLExporter(htmlWriter);
                htmlExporter.write(asmaDatabase, database, true, basePath);
                writer.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        messageQueue.sendInfo("ASMA database exported as HTML to " + htmlFile.getAbsolutePath() + " with " + MemoryUtility.getRoundedMemorySize(htmlFile.length()) + ".");
    }

    private void run(String[] args) {
        MessageQueue messageQueue = MessageQueueFactory.createSystemInstance();
        if (args.length != 2) {
            messageQueue.sendInfo("Usage: ASMAExporter <trunk/asma folder> <asmadb.js file>");
            return;
        }
        String sourceFolderPath = args[0];
        File sourceFolder = new File(sourceFolderPath);
        File stilFile = new File(sourceFolder, "Docs/STIL.txt");
        messageQueue.sendInfo("Loading STIL information '" + stilFile.getPath() + "'.");
        STIL stil = new STIL();
        try {
            stil.load(stilFile);
        }
        catch (IOException ex) {
            messageQueue.sendError("Cannot read STIL file: " + ex.getMessage());
            return;
        }
        messageQueue.sendInfo(String.valueOf(stil.getSize()) + " STIL entries loaded.");
        ASMADatabase asmaDatabase = new ASMADatabase();
        File composersFile = new File(sourceFolder, "Docs/ASMA-Composers.json");
        messageQueue.sendInfo("Loading composers from '" + composersFile.getPath() + "'.");
        ComposerList composerList = ComposerList.load(composersFile);
        composerList.deserialize();
        composerList.init(messageQueue);
        messageQueue.sendInfo(String.valueOf(composerList.getEntries().size()) + " composers loaded.");
        composerList.checkFolders(sourceFolder, messageQueue);
        asmaDatabase.composerList = composerList;
        File groupsFile = new File(sourceFolder, "Docs/ASMA-Groups.json");
        messageQueue.sendInfo("Loading groups from '" + composersFile.getPath() + "'.");
        GroupList groupList = GroupList.load(groupsFile);
        groupList.deserialize();
        messageQueue.sendInfo(String.valueOf(groupList.getEntries().size()) + " groups loaded.");
        groupList.init(messageQueue);
        groupList.checkFolders(sourceFolder, messageQueue);
        composerList.checkGroups(groupList, messageQueue);
        asmaDatabase.groupList = groupList;
        File databaseFile = new File(sourceFolder, "Docs/Demozoo-Database.json");
        messageQueue.sendInfo("Loading Demozoo database from '" + databaseFile.getPath() + "'.");
        Demozoo demozoo = new Demozoo();
        Database database = demozoo.loadDatabase(databaseFile, messageQueue);
        messageQueue.sendInfo(String.valueOf(database.productions.length) + " productions loaded.");
        ASMAProductionList productionList = new ASMAProductionList(database.productions);
        productionList.init();
        asmaDatabase.productionList = productionList;
        FileInfoList fileInfoList = new FileInfoList(stil, new ASAPFileLogic());
        int maxFiles = Integer.MAX_VALUE;
        fileInfoList.scanFolder(sourceFolder, messageQueue, maxFiles);
        fileInfoList.checkFileInfos(composerList, productionList);
        productionList.checkReferences(fileInfoList);
        asmaDatabase.fileInfoList = fileInfoList;
        File asmaDatabaseFile = new File(args[1]);
        this.exportJS(asmaDatabase, asmaDatabaseFile, messageQueue);
        File htmlFile = FileUtility.changeFileExtension(asmaDatabaseFile, ".html");
        this.exportHTML(asmaDatabase, database, htmlFile, "", messageQueue);
        String dateString = StringUtility.getToday();
        String baseName = "history";
        this.exportHTML(asmaDatabase, database, htmlFile, "", messageQueue);
        File htmlHistoryFolder = new File(htmlFile.getParentFile(), "history");
        File htmlHistoryFile = new File(htmlHistoryFolder, FileUtility.changeFileExtension(asmaDatabaseFile, "-" + dateString + ".html").getName());
        this.exportHTML(asmaDatabase, database, htmlHistoryFile, "../", messageQueue);
        messageQueue.printSummary();
    }

    public static final class FileExtension {
        public static final String SAP = ".sap";
        public static final String TTT = ".ttt";
    }
}

