/*
 * Decompiled with CFR 0.152.
 */
package org.atari.asma;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.atari.asma.ASMADatabase;
import org.atari.asma.FileInfo;
import org.atari.asma.HTMLWriter;
import org.atari.asma.demozoo.ASMAProduction;
import org.atari.asma.demozoo.model.AuthorNick;
import org.atari.asma.demozoo.model.Database;
import org.atari.asma.demozoo.model.Link;
import org.atari.asma.demozoo.model.Production;
import org.atari.asma.util.MessageQueue;
import org.atari.asma.util.StringUtility;

public class ASMAHTMLExporter {
    private HTMLWriter html;

    public ASMAHTMLExporter(HTMLWriter htmlWriter) {
        this.html = htmlWriter;
    }

    private static String getDemozooIDHTML(int demozooID) {
        String link = "https://demozoo.org/music/" + demozooID;
        String htmlString = HTMLWriter.getTextWithLink(Long.toString(demozooID), link);
        return htmlString;
    }

    private static String getASMAPlayerHTML(String urlFilePath) {
        urlFilePath = urlFilePath.replace('#', '/');
        String link = "https://asma.atari.org/asmadb/#/" + urlFilePath;
        String htmlString = HTMLWriter.getTextWithLink(urlFilePath, link);
        return htmlString;
    }

    private void writeMessageQueueCell(MessageQueue messageQueue) {
        StringBuilder htmlBuilder = new StringBuilder();
        List<MessageQueue.Entry> entries = messageQueue.getEntries();
        for (MessageQueue.Entry entry : entries) {
            String color = "";
            switch (entry.getType()) {
                case ERROR: {
                    color = "color:red;";
                    break;
                }
                case WARNING: {
                    color = "color:#FF8C00;";
                    break;
                }
            }
            htmlBuilder.append("<div style=\"" + color + "\">");
            htmlBuilder.append(entry.getType().toString()).append(" : ").append(entry.getMessage());
            htmlBuilder.append("</div>");
        }
        this.html.writeHTMLCell(htmlBuilder.toString());
    }

    private void writeHeader(String basePath) {
        StringBuilder htmlBuilder = new StringBuilder();
        htmlBuilder.append("<!DOCTYPE html>");
        htmlBuilder.append("<html lang=\"en\">");
        htmlBuilder.append("<head>");
        htmlBuilder.append("<title>Atari SAP Music Overview</title>");
        htmlBuilder.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">");
        htmlBuilder.append("<link href=\"+" + basePath + "../img/favicon.ico\" rel=\"shortcut icon\" type=\"image/vnd.microsoft.icon\">");
        htmlBuilder.append("<link rel=\"stylesheet\" href=\"" + basePath + "asma.css\" type=\"text/css\">");
        htmlBuilder.append("<meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">");
        htmlBuilder.append("<script src=\"" + basePath + "sorttable.js\"></script>");
        htmlBuilder.append("</head>");
        htmlBuilder.append("\n");
        this.html.write(htmlBuilder.toString());
    }

    private void writeMessageSummary(String dateTime, List<MessageQueue> messageQueueList) {
        int fileCount = 0;
        int fileWithIssuesCount = 0;
        int errorCount = 0;
        int warningCount = 0;
        for (MessageQueue messageQueue : messageQueueList) {
            ++fileCount;
            if (!ASMAHTMLExporter.hasIssues(messageQueue)) continue;
            ++fileWithIssuesCount;
            errorCount = (int)((long)errorCount + messageQueue.getErrorCount());
            warningCount = (int)((long)warningCount + messageQueue.getWarningCount());
        }
        this.html.beginTable();
        this.html.beginRow();
        this.html.writeHeaderTextCell("Date");
        this.html.writeHeaderTextCell("Entries");
        this.html.writeHeaderTextCell("Entries with Issues");
        this.html.writeHeaderTextCell("Errors");
        this.html.writeHeaderTextCell("Warnings");
        this.html.endRow();
        this.html.beginRow();
        this.html.writeTextCell(dateTime);
        this.html.writeLongCell(fileCount);
        this.html.writeLongCell(fileWithIssuesCount);
        this.html.writeLongCell(errorCount);
        this.html.writeLongCell(warningCount);
        this.html.endRow();
        this.html.endTable();
    }

    private void writeASMASummary(ASMADatabase asmaDatabase) {
        ArrayList<MessageQueue> messageQueueList = new ArrayList<MessageQueue>();
        for (FileInfo fileInfo : asmaDatabase.fileInfoList.getEntries()) {
            messageQueueList.add(fileInfo.getMessageQueue());
        }
        this.writeMessageSummary(StringUtility.getToday(), messageQueueList);
    }

    private void writeASMA(ASMADatabase asmaDatabase, boolean onlyIssues) {
        this.html.beginTable();
        this.html.beginRow();
        this.html.writeHeaderTextCell("Line");
        this.html.writeHeaderTextCell("File Path");
        this.html.writeHeaderTextCell("Title");
        this.html.writeHeaderTextCell("Author");
        this.html.writeHeaderTextCell("Date");
        this.html.writeHeaderTextCell("Channels");
        this.html.writeHeaderTextCell("Hardware");
        this.html.writeHeaderTextCell("Downloads");
        this.html.writeHeaderTextCell("Songs");
        this.html.writeHeaderTextCell("Demozoo ID");
        this.html.writeHeaderTextCell("Demozoo Title");
        this.html.writeHeaderTextCell("Demozoo Author");
        this.html.writeHeaderTextCell("Messages");
        this.html.endRow();
        int line = 1;
        for (FileInfo fileInfo : asmaDatabase.fileInfoList.getEntries()) {
            if (onlyIssues && !ASMAHTMLExporter.hasIssues(fileInfo.getMessageQueue())) continue;
            this.html.beginRow();
            this.html.writeLongCell(line);
            this.html.writeHTMLCell(ASMAHTMLExporter.getASMAPlayerHTML(fileInfo.filePath));
            this.html.writeTextCell(fileInfo.title);
            this.html.writeTextCell(fileInfo.author);
            this.html.writeTextCell(fileInfo.date);
            this.html.writeLongCell(fileInfo.channels);
            this.html.writeTextCell(fileInfo.hardware);
            this.html.writeTextCell(fileInfo.originalModuleExt);
            this.html.writeLongCell(fileInfo.songs);
            StringBuilder demozooIDBuilder = new StringBuilder();
            StringBuilder demozootTitleBuilder = new StringBuilder();
            StringBuilder demozooAuthorBuilder = new StringBuilder();
            int songNumber = 1;
            while (songNumber <= fileInfo.songs) {
                String urlFilePath = fileInfo.getURLFilePath(songNumber);
                ASMAProduction asmaProduction = asmaDatabase.productionList.getByURLFilePath(urlFilePath);
                if (asmaProduction != null) {
                    demozooIDBuilder.append("<div>").append(ASMAHTMLExporter.getDemozooIDHTML(asmaProduction.id));
                    demozootTitleBuilder.append("<div>").append(asmaProduction.title);
                    demozooAuthorBuilder.append("<div>");
                } else {
                    demozooIDBuilder.append("<div style=\"color:red;\">Missing</span>");
                    demozootTitleBuilder.append("<div>");
                    demozooAuthorBuilder.append("<div>");
                }
                demozooIDBuilder.append("</div>");
                demozootTitleBuilder.append("</div>");
                demozooAuthorBuilder.append("</div>");
                ++songNumber;
            }
            this.html.writeHTMLCell(demozooIDBuilder.toString());
            this.html.writeHTMLCell(demozootTitleBuilder.toString());
            this.html.writeHTMLCell(demozooAuthorBuilder.toString());
            this.writeMessageQueueCell(fileInfo.getMessageQueue());
            this.html.endRow();
            ++line;
        }
        this.html.endTable();
    }

    private void writeDemozooSummary(Database database) {
        ArrayList<MessageQueue> messageQueueList = new ArrayList<MessageQueue>();
        Production[] productionArray = database.productions;
        int n = database.productions.length;
        int n2 = 0;
        while (n2 < n) {
            Production production = productionArray[n2];
            messageQueueList.add(production.getMessageQueue());
            ++n2;
        }
        this.writeMessageSummary(database.updateDateTime.substring(0, 10), messageQueueList);
    }

    private void writeDemozoo(Database database, boolean onlyIssues) {
        this.html.beginTable();
        this.html.beginRow();
        this.html.writeHeaderTextCell("Line");
        this.html.writeHeaderTextCell("ID");
        this.html.writeHeaderTextCell("Title");
        this.html.writeHeaderTextCell("Author");
        this.html.writeHeaderTextCell("Release Date");
        this.html.writeHeaderTextCell("Hardware");
        this.html.writeHeaderTextCell("Downloads");
        this.html.writeHeaderTextCell("File Extensions");
        this.html.writeHeaderTextCell("Tags");
        this.html.writeHeaderTextCell("URL File Path");
        this.html.writeHeaderTextCell("Messages");
        this.html.endRow();
        int line = 1;
        Production[] productionArray = database.productions;
        int n = database.productions.length;
        int n2 = 0;
        while (n2 < n) {
            Production production = productionArray[n2];
            if (!onlyIssues || ASMAHTMLExporter.hasIssues(production.getMessageQueue())) {
                this.html.beginRow();
                this.html.writeLongCell(line);
                this.html.writeHTMLCell(ASMAHTMLExporter.getDemozooIDHTML(production.id));
                this.html.writeTextCell(production.title);
                StringBuilder authorHTMLBuilder = new StringBuilder();
                AuthorNick[] authorNickArray = production.author_nicks;
                int n3 = production.author_nicks.length;
                int n4 = 0;
                while (n4 < n3) {
                    AuthorNick authorNick = authorNickArray[n4];
                    authorHTMLBuilder.append(authorNick.releaser.id).append("<br>");
                    ++n4;
                }
                this.html.writeTextCell(authorHTMLBuilder.toString());
                this.html.writeTextCell(production.release_date);
                this.html.writeTextCell(production.getHardware());
                TreeSet<String> downloadLinks = new TreeSet<String>();
                Link[] linkArray = production.download_links;
                int n5 = production.download_links.length;
                n3 = 0;
                while (n3 < n5) {
                    Link link = linkArray[n3];
                    downloadLinks.add(link.url);
                    ++n3;
                }
                StringBuilder downloadLinkHTMLBuilder = new StringBuilder();
                for (String link : downloadLinks) {
                    downloadLinkHTMLBuilder.append("<p>");
                    String text = "";
                    try {
                        URI uri = new URI(link);
                        text = uri.getHost();
                    }
                    catch (URISyntaxException ex) {
                        text = ex.toString();
                    }
                    downloadLinkHTMLBuilder.append("<a href=\"" + link + "\">" + text + "</a>");
                    downloadLinkHTMLBuilder.append("<p/>");
                }
                this.html.writeHTMLCell(downloadLinkHTMLBuilder.toString());
                Set<String> fileExtensions = production.getFileExtensions();
                this.html.writeTextCell(StringUtility.toString(fileExtensions));
                this.html.writeTextCell(production.getTags());
                List<String> urlFilePaths = production.getASMAURLFilePaths();
                StringBuilder urlFilePathsHTMLBuilder = new StringBuilder();
                for (String urlFilePath : urlFilePaths) {
                    urlFilePathsHTMLBuilder.append("<div>");
                    urlFilePathsHTMLBuilder.append(ASMAHTMLExporter.getASMAPlayerHTML(urlFilePath));
                    urlFilePathsHTMLBuilder.append("</div>");
                }
                this.html.writeHTMLCell(urlFilePathsHTMLBuilder.toString());
                this.writeMessageQueueCell(production.getMessageQueue());
                this.html.endRow();
                ++line;
            }
            ++n2;
        }
        this.html.endTable();
    }

    private static boolean hasIssues(MessageQueue messageQueue) {
        return messageQueue.getErrorCount() > 0L || messageQueue.getWarningCount() > 0L;
    }

    public void write(ASMADatabase asmaDatabase, Database database, boolean onlyIssues, String basePath) {
        this.writeHeader(basePath);
        this.html.beginHeading("toc");
        this.html.writeText("Table of Contents");
        this.html.endHeading();
        this.html.beginParagraph();
        this.html.writeText("ASMA", "#asma");
        this.html.endParagraph();
        this.writeASMASummary(asmaDatabase);
        this.html.beginParagraph();
        this.html.writeText("Demozoo", "#demozoo");
        this.html.endParagraph();
        this.writeDemozooSummary(database);
        this.html.beginHeading("asma");
        this.html.writeText("ASMA");
        this.html.endHeading();
        this.writeASMA(asmaDatabase, onlyIssues);
        this.html.beginHeading("demozoo");
        this.html.writeText("Demozoo");
        this.html.endHeading();
        this.writeDemozoo(database, onlyIssues);
    }
}

