/*
 * Decompiled with CFR 0.152.
 */
package org.atari.asma;

import java.util.ArrayList;
import java.util.List;

public class Composer {
    public String folderName = "";
    public String lastName = "";
    public String firstName = "";
    public String lastnNameUnicode = "";
    public String firstNameUnicode = "";
    public String handles = "";
    public String country = "";
    public String demozooID = "";
    public String groups = "";

    public String toString() {
        if (!this.folderName.isEmpty()) {
            return this.folderName;
        }
        return String.valueOf(this.firstName) + " " + this.lastName + " (" + this.handles + ")";
    }

    public String[] getHandlesArray() {
        String[] result = this.handles.split(",");
        int i = 0;
        while (i < result.length) {
            result[i] = result[i].trim();
            ++i;
        }
        return result;
    }

    public String getDefaultFolderName() {
        if (this.lastName.equals("<?>")) {
            return Composer.normalize(this.getHandlesArray()[0]);
        }
        return String.valueOf(Composer.normalize(this.lastName)) + "_" + Composer.normalize(this.firstName);
    }

    private static String normalize(String name) {
        name = name.replaceAll(" ", "_");
        name = name.replaceAll("-", "_");
        name = name.replaceAll("\\.", "");
        return name;
    }

    public List<String> getAuthors() {
        ArrayList<String> result = new ArrayList<String>();
        String[] handles = this.handles.split(",");
        if (handles.length == 0) {
            result.add(this.getAuthor(""));
        } else {
            String[] stringArray = handles;
            int n = handles.length;
            int n2 = 0;
            while (n2 < n) {
                String handle = stringArray[n2];
                result.add(this.getAuthor(handle.trim()));
                ++n2;
            }
        }
        return result;
    }

    private String getAuthor(String handle) {
        StringBuilder result = new StringBuilder();
        if (!this.firstName.isEmpty()) {
            result.append(this.firstName);
            result.append(" ");
        }
        result.append(this.lastName);
        if (!handle.isEmpty()) {
            result.append(" (");
            result.append(handle);
            result.append(")");
        }
        return result.toString();
    }
}

