/*
 * Decompiled with CFR 0.152.
 */
package org.atari.asma;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.atari.asma.Composer;
import org.atari.asma.GroupList;
import org.atari.asma.util.FileUtility;
import org.atari.asma.util.MessageQueue;

public class ComposerList {
    private String jsonString;
    private List<Composer> composerList;
    private Map<String, Composer> composerByFolderName;
    private Map<String, Composer> composerByDemozooID;

    private ComposerList(String jsonString) {
        this.jsonString = jsonString;
        this.composerList = new ArrayList<Composer>();
        this.composerByFolderName = new TreeMap<String, Composer>();
        this.composerByDemozooID = new TreeMap<String, Composer>();
    }

    public static ComposerList load(File file) {
        String jsonString = FileUtility.readAsString(file);
        ComposerList result = new ComposerList(jsonString);
        return result;
    }

    public String getJSONString() {
        return this.jsonString;
    }

    public void deserialize() {
        Gson gson = new GsonBuilder().create();
        Type composerListType = new TypeToken<ArrayList<Composer>>(){}.getType();
        this.composerList = (List)gson.fromJson(this.jsonString, composerListType);
    }

    public void init(MessageQueue messageQueue) {
        for (Composer composer : this.composerList) {
            Composer previousComposer;
            if (!composer.folderName.isEmpty()) {
                previousComposer = this.composerByFolderName.put(composer.folderName, composer);
                if (previousComposer != null) {
                    throw new RuntimeException("Composer \\\"" + previousComposer.toString() + "\" is already registered for folder name \"" + previousComposer.folderName + "\" of composer \"" + composer.toString() + "\"");
                }
                String defaultFolderName = composer.getDefaultFolderName();
                if (!composer.folderName.equals(defaultFolderName)) {
                    messageQueue.sendError("COM-001: Folder \"" + composer.folderName + "\" of \"" + composer.toString() + "\" is different from default folder name \"" + defaultFolderName + "\"");
                }
            } else {
                messageQueue.sendError("COM-002: \"" + composer.toString() + "\" has no folder path");
            }
            if (!composer.demozooID.isEmpty()) {
                previousComposer = this.composerByDemozooID.put(composer.demozooID, composer);
                if (previousComposer == null) continue;
                throw new RuntimeException("Composer \"" + previousComposer.toString() + "\" is already registered for Demozoo ID " + previousComposer.demozooID + " of composer \"" + composer.toString() + "\"");
            }
            messageQueue.sendError("COM-003: Composer \"" + composer.toString() + "\" has no Demozoo ID");
        }
    }

    public List<Composer> getEntries() {
        return this.composerList;
    }

    public Composer getByFolderName(String folderName) {
        return this.composerByFolderName.get(folderName);
    }

    public Composer getByDemozooID(String demozooID) {
        return this.composerByDemozooID.get(demozooID);
    }

    public void checkFolders(File sourceFolder, MessageQueue messageQueue) {
        File[] composerFolders;
        if (sourceFolder == null) {
            throw new IllegalArgumentException("Parameter sourceFolder must not be null.");
        }
        File composersFolder = new File(sourceFolder, "Composers");
        for (Composer composer : this.composerList) {
            if (composer.folderName.isEmpty()) continue;
            File composerFolder = new File(composersFolder, composer.folderName);
            if (!composerFolder.exists()) {
                messageQueue.sendError("COM-004: Folder " + composerFolder.toString() + " of \"" + composer.toString() + "\" does not exist");
                continue;
            }
            if (composerFolder.isDirectory()) continue;
            messageQueue.sendError("COM-005: Path " + composerFolder.toString() + " of \"" + composer.toString() + "\" is not a directory");
        }
        File[] fileArray = composerFolders = composersFolder.listFiles();
        int n = composerFolders.length;
        int n2 = 0;
        while (n2 < n) {
            File composerFolder = fileArray[n2];
            if (!composerFolder.isDirectory()) {
                messageQueue.sendError("COM-006: Path " + composerFolder.toString() + "  is not a directory");
            } else {
                String folderName = composerFolder.getName();
                if (this.getByFolderName(folderName) == null) {
                    messageQueue.sendError("COM-007: Folder " + composerFolder.toString() + " has no entry in composer list");
                }
            }
            ++n2;
        }
    }

    public void checkGroups(GroupList groupList, MessageQueue messageQueue) {
        for (Composer composer : this.composerList) {
            String[] groupsFolderNameArray;
            if (composer.groups.isBlank()) continue;
            String[] stringArray = groupsFolderNameArray = composer.groups.split(",");
            int n = groupsFolderNameArray.length;
            int n2 = 0;
            while (n2 < n) {
                String groupFolderName = stringArray[n2];
                if (groupList.getByFolderName(groupFolderName) == null) {
                    messageQueue.sendError("COM-008: Group folder " + groupFolderName + " of composer " + composer.toString() + " has not entry in group list");
                }
                ++n2;
            }
        }
    }
}

