/*
 * Decompiled with CFR 0.152.
 */
package org.atari.asma;

import java.io.IOException;
import net.sf.asap.ASAPFormatException;
import net.sf.asap.ASAPInfo;
import org.atari.asma.sap.ASAPFile;
import org.atari.asma.util.JSONWriter;
import org.atari.asma.util.MessageQueue;

public final class FileInfo {
    public static String ATARI800 = "ATARI800";
    public static String ATARI2600 = "ATARI2600";
    public String filePath;
    public long fileSize;
    public String hardware;
    public String title;
    public String author;
    public String date;
    public String comment;
    public String typeLetter;
    public String originalModuleExt;
    public int channels;
    public int songs;
    public int defaultSongIndex;
    private transient MessageQueue messageQueue = new MessageQueue();
    private int demozooID;

    public String getURLFilePath(int songNumber) {
        if (this.songs > 0 && songNumber - 1 != this.defaultSongIndex) {
            return String.valueOf(this.filePath) + "#" + songNumber;
        }
        return this.filePath;
    }

    public int getDemozooID() {
        return this.demozooID;
    }

    public void setDemozooID(int demozooID) {
        this.demozooID = demozooID;
    }

    public MessageQueue getMessageQueue() {
        return this.messageQueue;
    }

    public void readFromSAPFile(ASAPFile sapFile) {
        ASAPInfo asapInfo = sapFile.getASAPInfo();
        this.title = asapInfo.getTitleOrFilename();
        this.author = asapInfo.getAuthor();
        this.date = asapInfo.getDate();
        this.typeLetter = String.valueOf((char)asapInfo.getTypeLetter());
        this.originalModuleExt = asapInfo.getOriginalModuleExt();
        if (this.originalModuleExt == null) {
            this.originalModuleExt = this.filePath.substring(this.filePath.lastIndexOf(46) + 1);
        }
        try {
            ASAPInfo.getExtDescription((String)this.originalModuleExt);
        }
        catch (ASAPFormatException ex) {
            throw new RuntimeException(ex);
        }
        this.channels = asapInfo.getChannels();
        this.songs = asapInfo.getSongs();
        this.defaultSongIndex = asapInfo.getDefaultSong();
        this.demozooID = 0;
    }

    public void write(JSONWriter writer) throws IOException {
        if (writer == null) {
            throw new IllegalArgumentException("Parameter writer must not be null.");
        }
        writer.beginObject();
        writer.writeJSONString("filePath", this.filePath);
        writer.writeSeparator();
        writer.writeJSONLong("fileSize", this.fileSize);
        writer.writeSeparator();
        if (!this.hardware.equals(ATARI800)) {
            writer.writeJSONString("hardware", this.hardware);
            writer.writeSeparator();
        }
        writer.writeJSONString("title", this.title);
        writer.writeSeparator();
        writer.writeJSONString("author", this.author);
        writer.writeSeparator();
        writer.writeJSONString("date", this.date);
        if (this.comment != null) {
            writer.writeSeparator();
            writer.writeJSONString("comment", this.comment);
        }
        writer.writeSeparator();
        writer.writeJSONString("typeLetter", this.typeLetter);
        writer.writeSeparator();
        writer.writeJSONString("originalModuleExt", this.originalModuleExt);
        if (this.channels != 1) {
            writer.writeSeparator();
            writer.writeJSONLong("channels", this.channels);
        }
        if (this.songs != 1) {
            writer.writeSeparator();
            writer.writeJSONLong("songs", this.songs);
        }
        if (this.defaultSongIndex != 0) {
            writer.writeSeparator();
            writer.writeJSONLong("defaultSongIndex", this.defaultSongIndex);
            if (this.defaultSongIndex < 0) {
                throw new IllegalArgumentException("Invalid default song index " + this.defaultSongIndex);
            }
        }
        if (this.demozooID != 0) {
            writer.writeSeparator();
            writer.writeJSONLong("demozooID", this.demozooID);
        }
        writer.endObject();
    }
}

