/*
 * Decompiled with CFR 0.152.
 */
package org.atari.asma;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.atari.asma.Composer;
import org.atari.asma.ComposerList;
import org.atari.asma.FileInfo;
import org.atari.asma.STIL;
import org.atari.asma.TTTFile;
import org.atari.asma.demozoo.ASMAProduction;
import org.atari.asma.demozoo.ASMAProductionList;
import org.atari.asma.sap.ASAPFile;
import org.atari.asma.sap.ASAPFileLogic;
import org.atari.asma.util.FileUtility;
import org.atari.asma.util.JSONWriter;
import org.atari.asma.util.MessageQueue;

public class FileInfoList {
    private STIL stil;
    private ASAPFileLogic sapFileLogic;
    private List<FileInfo> fileInfoList;
    private Gson gson;

    public FileInfoList(STIL stil, ASAPFileLogic sapFileLogic) {
        this.stil = stil;
        this.sapFileLogic = sapFileLogic;
        this.fileInfoList = new ArrayList<FileInfo>();
        this.gson = new GsonBuilder().create();
    }

    public List<FileInfo> getEntries() {
        return this.fileInfoList;
    }

    public void exportToJSON(JSONWriter writer) throws IOException {
        boolean first = true;
        writer.beginArray();
        for (FileInfo songInfo : this.fileInfoList) {
            if (first) {
                first = false;
            } else {
                writer.writeSeparator();
            }
            songInfo.write(writer);
        }
        writer.endArray();
    }

    public void scanFolder(File sourceFolder, MessageQueue messageQueue, int maxFiles) {
        messageQueue.sendInfo("Scanning " + sourceFolder.getAbsolutePath());
        List<File> fileList = FileUtility.getRecursiveFileList(sourceFolder, new FileFilter(){

            @Override
            public boolean accept(File file) {
                String fileName = file.getName().toLowerCase();
                return fileName.endsWith(".sap") || fileName.endsWith(".ttt");
            }
        });
        messageQueue.sendInfo(String.valueOf(fileList.size()) + " matching files found.");
        int index = sourceFolder.getAbsolutePath().length() + 1;
        AtomicInteger count = new AtomicInteger();
        int blockSize = 100;
        int i = 0;
        while (i < fileList.size() / 100) {
            System.out.print("=");
            ++i;
        }
        System.out.println();
        MessageQueue fileListMessageQueue = new MessageQueue();
        AtomicBoolean cancelled = new AtomicBoolean();
        fileList.parallelStream().forEach(file -> {
            if (!cancelled.get()) {
                if (count.incrementAndGet() % 100 == 0) {
                    System.out.print("^");
                }
                String filePath = file.getAbsolutePath().substring(index);
                filePath = filePath.replace(File.separator, "/");
                MessageQueue fileMessageQueue = new MessageQueue();
                FileInfo fileInfo = this.readFile((File)file, filePath, fileMessageQueue);
                Object object = messageQueue;
                synchronized (object) {
                    fileListMessageQueue.addEntries(fileMessageQueue);
                }
                object = this.fileInfoList;
                synchronized (object) {
                    if (fileInfo != null) {
                        this.fileInfoList.add(fileInfo);
                        if (this.fileInfoList.size() >= maxFiles) {
                            cancelled.set(true);
                        }
                    }
                }
            }
        });
        System.out.println();
        this.fileInfoList.sort(new Comparator<FileInfo>(){

            @Override
            public int compare(FileInfo o1, FileInfo o2) {
                return o1.filePath.compareTo(o2.filePath);
            }
        });
        messageQueue.addEntries(fileListMessageQueue);
    }

    private FileInfo readFile(File file, String filePath, MessageQueue messageQueue) {
        byte[] module = FileUtility.readAsByteArray(file);
        FileInfo fileInfo = new FileInfo();
        fileInfo.filePath = filePath;
        fileInfo.fileSize = file.length();
        if (filePath.toLowerCase().endsWith(".sap")) {
            fileInfo.hardware = FileInfo.ATARI800;
            ASAPFile sapFile = this.sapFileLogic.loadSAPFile(file, messageQueue);
            if (sapFile == null) {
                messageQueue.sendInfo("Error reading '" + file.getAbsolutePath() + "'. See above.");
                return null;
            }
            fileInfo.readFromSAPFile(sapFile);
            STIL.STILEntry sTILEntry = this.stil.getSTILEntry("/" + filePath);
        } else if (filePath.toLowerCase().endsWith(".ttt")) {
            fileInfo.hardware = FileInfo.ATARI2600;
            String jsonString = new String(module, StandardCharsets.UTF_8);
            TTTFile tttFile = (TTTFile)this.gson.fromJson(jsonString, TTTFile.class);
            fileInfo.title = tttFile.metaName;
            fileInfo.author = tttFile.metaAuthor;
            fileInfo.date = "";
            fileInfo.comment = tttFile.metaComment;
            fileInfo.typeLetter = "T";
            fileInfo.originalModuleExt = "ttt";
            fileInfo.channels = 1;
            fileInfo.songs = 1;
            fileInfo.defaultSongIndex = 0;
        } else {
            throw new IllegalArgumentException("Unsupport file extension in " + filePath);
        }
        return fileInfo;
    }

    public void checkFileInfos(ComposerList composerList, ASMAProductionList productionList) {
        int MAX_FILE_NAME_LENGTH = 26;
        String FILE_NAME_CHARACTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_";
        String COMPOSERS = "Composers/";
        int startIndex = "Composers/".length();
        for (FileInfo fileInfo : this.fileInfoList) {
            String filePath = fileInfo.filePath;
            MessageQueue messageQueue = fileInfo.getMessageQueue();
            if (filePath.toLowerCase().endsWith(".sap")) {
                int length;
                if (!filePath.endsWith(".sap")) {
                    messageQueue.sendError("SAP-101: File " + fileInfo.filePath + " does not have a lowercase \".sap\" file extension");
                }
                String fileName = filePath;
                int index = filePath.lastIndexOf(47);
                if (index >= 0) {
                    fileName = fileName.substring(index + 1);
                }
                if ((length = (fileName = fileName.substring(0, fileName.length() - ".sap".length())).length()) > 26) {
                    messageQueue.sendError("SAP-102: File " + fileInfo.filePath + " has a file name with more than " + 26 + " characters. Use a shorter name.");
                }
                int i = 0;
                while (i < fileName.length()) {
                    char c = fileName.charAt(i);
                    if ("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_".indexOf(c) < 0) {
                        messageQueue.sendError("SAP-103: File " + fileInfo.filePath + " has a file name with the invalid character \"" + c + "\" at index " + i + ".");
                    }
                    ++i;
                }
            }
            if (filePath.startsWith("Composers/")) {
                int index = filePath.indexOf("/", startIndex);
                String folderName = filePath.substring(startIndex, index);
                Composer composer = composerList.getByFolderName(folderName);
                if (composer != null) {
                    String[] fileAuthors;
                    List<String> authors = composer.getAuthors();
                    String[] stringArray = fileAuthors = fileInfo.author.split(" & ");
                    int n = fileAuthors.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String fileAuthor = stringArray[n2];
                        String questionMark = " <?>";
                        boolean unsafe = false;
                        if (fileAuthor.endsWith(" <?>")) {
                            unsafe = true;
                            fileAuthor = fileAuthor.substring(0, fileAuthor.length() - " <?>".length());
                        }
                        if (!authors.contains(fileAuthor)) {
                            messageQueue.sendError("SAP-103: File " + fileInfo.filePath + " author " + fileAuthor + " in " + fileInfo.author + " is differnt from all composer authors " + authors.toString());
                        } else if (unsafe) {
                            messageQueue.sendInfo("SAP-104: File " + fileInfo.filePath + " author " + fileAuthor + " in " + fileInfo.author + " is unsafe");
                        }
                        ++n2;
                    }
                } else {
                    messageQueue.sendError("SAP-105: File " + fileInfo.filePath + " has unknown composer path");
                }
            }
            int songIndex = 0;
            while (songIndex < fileInfo.songs) {
                int songNumber = songIndex + 1;
                String urlFilePath = fileInfo.getURLFilePath(songNumber);
                ASMAProduction production = productionList.getByURLFilePath(urlFilePath);
                if (production != null) {
                    fileInfo.setDemozooID(production.id);
                } else if (fileInfo.songs == 1) {
                    messageQueue.sendError("SAP-106: File " + fileInfo.filePath + " has no Demozoo ID.");
                } else {
                    messageQueue.sendError("SAP-107: Song number " + songNumber + " in File " + fileInfo.filePath + " has no Demozoo ID.");
                }
                ++songIndex;
            }
        }
    }
}

