/*
 * Decompiled with CFR 0.152.
 */
package org.atari.asma;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.atari.asma.Group;
import org.atari.asma.util.FileUtility;
import org.atari.asma.util.MessageQueue;

public class GroupList {
    private String jsonString;
    private List<Group> groupList;
    private Map<String, Group> groupByFolderName;
    private Map<String, Group> groupByDemozooID;

    private GroupList(String jsonString) {
        this.jsonString = jsonString;
        this.groupList = new ArrayList<Group>();
        this.groupByFolderName = new TreeMap<String, Group>();
        this.groupByDemozooID = new TreeMap<String, Group>();
    }

    public String getJSONString() {
        return this.jsonString;
    }

    public static GroupList load(File file) {
        String jsonString = FileUtility.readAsString(file);
        GroupList result = new GroupList(jsonString);
        return result;
    }

    public void deserialize() {
        Gson gson = new GsonBuilder().create();
        Type groupListType = new TypeToken<ArrayList<Group>>(){}.getType();
        this.groupList = (List)gson.fromJson(this.jsonString, groupListType);
    }

    public void init(MessageQueue messageQueue) {
        for (Group group : this.groupList) {
            Group previousGroup;
            if (!group.folderName.isEmpty()) {
                previousGroup = this.groupByFolderName.put(group.folderName, group);
                if (previousGroup != null) {
                    throw new RuntimeException("Group " + previousGroup.toString() + " already registered for folder name " + previousGroup.folderName + " of group " + group.toString());
                }
            } else {
                messageQueue.sendError("GRP-001: Group " + group.toString() + " has no folder path");
            }
            if (!group.demozooID.isEmpty()) {
                previousGroup = this.groupByDemozooID.put(group.demozooID, group);
                if (previousGroup == null) continue;
                throw new RuntimeException("Group " + previousGroup.toString() + " already registered for Demozoo ID " + previousGroup.demozooID + " of group " + group.toString());
            }
            if (group.handle.isEmpty()) continue;
            messageQueue.sendError("GRP-002: Group " + group.toString() + " has no Demozoo ID");
        }
    }

    public List<Group> getEntries() {
        return this.groupList;
    }

    public Group getByFolderName(String folderName) {
        return this.groupByFolderName.get(folderName);
    }

    public Group getByDemozooID(String demozooID) {
        return this.groupByDemozooID.get(demozooID);
    }

    public void checkFolders(File sourceFolder, MessageQueue messageQueue) {
        File[] groupFolders;
        if (sourceFolder == null) {
            throw new IllegalArgumentException("Parameter 'sourceFolder' must not be null.");
        }
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        File groupsFolder = new File(sourceFolder, "Groups");
        for (Group group : this.groupList) {
            if (group.folderName.isEmpty()) continue;
            File groupFolder = new File(groupsFolder, group.folderName);
            if (!groupFolder.exists()) {
                messageQueue.sendError("GRP-003: Folder " + groupFolder.toString() + " of group\"" + group.toString() + "\" does not exist");
                continue;
            }
            if (groupFolder.isDirectory()) continue;
            messageQueue.sendError("GRP-004: Path " + groupFolder.toString() + " of group \"" + group.toString() + "\" is not a directory");
        }
        File[] fileArray = groupFolders = groupsFolder.listFiles();
        int n = groupFolders.length;
        int n2 = 0;
        while (n2 < n) {
            File groupFolder = fileArray[n2];
            if (!groupFolder.isDirectory()) {
                messageQueue.sendError("GRP-005: Path " + groupFolder.toString() + " is not a directory");
            } else {
                String folderName = groupFolder.getName();
                if (this.getByFolderName(folderName) == null) {
                    messageQueue.sendError("GRP-006: Folder " + groupFolder.toString() + " has not entry in group list");
                }
            }
            ++n2;
        }
    }
}

