/*
 * Decompiled with CFR 0.152.
 */
package org.atari.asma;

import java.io.IOException;
import java.io.Writer;

public class HTMLWriter {
    private Writer writer;
    private int headingLevel;

    public HTMLWriter(Writer writer) {
        this.writer = writer;
        this.headingLevel = 0;
    }

    public static String encodeHTML(String text) {
        text = text.replace("\"", "&quot;");
        return text;
    }

    public static String getTextWithLink(String text, String link) {
        if (text == null) {
            text = "";
        }
        StringBuilder builder = new StringBuilder();
        if (link != null) {
            String encodedLink = link;
            builder.append("<a href=\"" + encodedLink + "\" target=\"_blank\">");
        }
        builder.append(HTMLWriter.encodeHTML(text));
        if (link != null) {
            builder.append("</a>");
        }
        return builder.toString();
    }

    public void write(String html) {
        try {
            this.writer.write(html);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String beginHeading(String id) {
        ++this.headingLevel;
        this.write("<h" + this.headingLevel + " id=\"" + id + "\">");
        return id;
    }

    public void writeText(String text) {
        this.writeText(text, null);
    }

    public void writeText(String text, String link) {
        String html = HTMLWriter.getTextWithLink(text, link);
        this.write(html);
    }

    public void endHeading() {
        this.write("</h" + this.headingLevel + ">");
        --this.headingLevel;
    }

    public void beginParagraph() {
        this.write("<p>");
    }

    public void endParagraph() {
        this.write("</p>");
    }

    public void beginTable() {
        this.write("<table border=\"1\" style=\"border-collapse:collapse\">");
    }

    public void endTable() {
        this.write("</table>");
    }

    public void beginRow() {
        this.write("<tr>");
    }

    public void endRow() {
        this.write("</tr>");
    }

    public void writeHeaderTextCell(String text) {
        this.write("<th>");
        this.write(HTMLWriter.encodeHTML(text));
        this.write("</th>");
    }

    public void writeHTMLCell(String html) {
        this.write("<td>");
        this.write(html);
        this.write("</td>");
    }

    public void writeLongCell(long value) {
        this.writeLongCell(value, null);
    }

    public void writeLongCell(long value, String link) {
        this.writeTextCell(Long.toString(value), link);
    }

    public void writeTextCell(String text) {
        this.writeTextCell(text, null);
    }

    public void writeTextCell(String text, String link) {
        String html = HTMLWriter.getTextWithLink(text, link);
        this.writeHTMLCell(html);
    }
}

