/*
 * Decompiled with CFR 0.152.
 */
package org.atari.asma;

public class RMTFile {
    public static String RMT4 = "RMT4";
    public static String RMT8 = "RMT8";
    public final int startAddress;
    public final int endAddress;
    public final byte[] content;

    public static String getType(byte[] content) {
        if (content.length > 4 && content[0] == 82 && content[1] == 77 && content[2] == 84) {
            if (content[3] == 52) {
                return "RMT4";
            }
            if (content[3] == 56) {
                return "RMT8";
            }
        }
        return "";
    }

    public RMTFile(int startAddress, int endAddress, byte[] content) {
        this.startAddress = startAddress;
        this.endAddress = endAddress;
        this.content = content;
    }

    public String getHeaderString() {
        return RMTFile.getType(this.content);
    }

    public int getTrackLength() {
        int result = this.getByte(4);
        if (result == 0) {
            result = 256;
        }
        return result;
    }

    public int getSongSpeed() {
        return this.getByte(5);
    }

    public int getPlayerFrequency() {
        return this.getByte(6);
    }

    public int getFormatVersionNumber() {
        return this.getByte(5);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Header: ").append(this.getHeaderString()).append("\n");
        sb.append("Track Length: ").append(this.getTrackLength()).append("\n");
        sb.append("Song Speed ").append(this.getSongSpeed()).append("\n");
        sb.append("Player Frequency: ").append(this.getPlayerFrequency()).append("\n");
        sb.append("Format Version Number: ").append(this.getFormatVersionNumber()).append("\n");
        return sb.toString();
    }

    private int getByte(int offset) {
        return this.content[offset];
    }

    public static class Instrument {
    }

    public static class Track {
    }
}

