/*
 * Decompiled with CFR 0.152.
 */
package org.atari.asma;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class STIL {
    private Map<String, STILEntry> fastMap = new HashMap<String, STILEntry>();

    void load(File inputFile) throws IOException {
        this.fastMap.clear();
        Pattern p = Pattern.compile("(NAME|AUTHOR|TITLE|ARTIST|COMMENT): *(.*)");
        STILEntry entry = null;
        TuneEntry tuneEntry = null;
        Info lastInfo = null;
        String lastProp = null;
        StringBuilder cmts = new StringBuilder();
        FileReader reader = null;
        BufferedReader bufferedReader = null;
        try {
            String line;
            reader = new FileReader(inputFile, StandardCharsets.UTF_8);
            bufferedReader = new BufferedReader(reader);
            int lineNumber = 0;
            while ((line = bufferedReader.readLine()) != null) {
                if (++lineNumber == 1 && line.charAt(0) == '\ufeff') {
                    line = line.substring(1);
                }
                if (line.startsWith("#")) {
                    cmts.append(String.valueOf(line.trim()) + "\n");
                    continue;
                }
                if (line.startsWith("/")) {
                    entry = new STILEntry(line);
                    this.fastMap.put(line, entry);
                    entry.comment = cmts.toString();
                    cmts.delete(0, cmts.length());
                    lastInfo = new Info();
                    entry.infos.add(lastInfo);
                    tuneEntry = null;
                    lastProp = null;
                    continue;
                }
                if (line.startsWith("(#")) {
                    if (entry == null) {
                        throw new RuntimeException("Invalid format in STIL file: '(#' before '/' in line " + lineNumber + ".");
                    }
                    int end = line.indexOf(")");
                    int tuneNo = Integer.parseInt(line.substring(2, end));
                    tuneEntry = new TuneEntry();
                    tuneEntry.tuneNo = tuneNo;
                    entry.subTunes.add(tuneEntry);
                    lastInfo = new Info();
                    tuneEntry.infos.add(lastInfo);
                    lastProp = null;
                    continue;
                }
                if ("".equals(line = line.trim())) continue;
                if (entry == null) {
                    throw new RuntimeException("No entry to put data in '" + line + "' in line \"+lineNumber+\".");
                }
                if (lastInfo == null) {
                    throw new RuntimeException("No context to put data in '" + line + "' in line \"+lineNumber+\".");
                }
                try {
                    Matcher m = p.matcher(line);
                    if (m.matches()) {
                        lastProp = m.group(1);
                        Field f = STIL.getField(lastInfo, lastProp);
                        if (f.get(lastInfo) != null) {
                            lastInfo = new Info();
                            if (tuneEntry != null) {
                                tuneEntry.infos.add(lastInfo);
                            } else {
                                entry.infos.add(lastInfo);
                            }
                        }
                        f.set(lastInfo, m.group(2));
                        continue;
                    }
                    if (lastProp == null) continue;
                    Field f = STIL.getField(lastInfo, lastProp);
                    f.set(lastInfo, f.get(lastInfo) + "\n" + line);
                }
                catch (IllegalAccessException ex) {
                    throw new RuntimeException("Illegal access exception in line " + lineNumber + ".", ex);
                }
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (reader != null) {
                ((Reader)reader).close();
            }
        }
    }

    private static Field getField(Info lastInfo, String lastProp) {
        try {
            Field f = lastInfo.getClass().getField(lastProp.toLowerCase(Locale.ENGLISH));
            return f;
        }
        catch (NoSuchFieldException ex) {
            throw new RuntimeException(ex);
        }
    }

    public int getSize() {
        return this.fastMap.size();
    }

    public STILEntry getSTILEntry(String collectionName) {
        return this.fastMap.get(collectionName);
    }

    public static final class Info {
        public String name;
        public String author;
        public String title;
        public String artist;
        public String comment;

        public String toString() {
            return "info";
        }
    }

    public static class STILEntry {
        private String comment;
        private String filename;
        private List<TuneEntry> subTunes = new ArrayList<TuneEntry>();
        private List<Info> infos = new ArrayList<Info>();

        public STILEntry(String name) {
            this.filename = name;
        }

        public String getComment() {
            return this.comment;
        }

        public String getFilename() {
            return this.filename;
        }

        public List<TuneEntry> getSubTunes() {
            return this.subTunes;
        }

        public List<Info> getInfos() {
            return this.infos;
        }

        public String toString() {
            return this.filename.substring(this.filename.lastIndexOf(47) + 1);
        }
    }

    public static final class TuneEntry {
        public int tuneNo = -1;
        public List<Info> infos = new ArrayList<Info>();

        public String toString() {
            return "" + this.tuneNo;
        }
    }
}

