/*
 * Decompiled with CFR 0.152.
 */
package org.atari.asma.demozoo;

import java.util.Iterator;
import java.util.TreeSet;
import org.atari.asma.demozoo.model.AuthorNick;
import org.atari.asma.demozoo.model.Production;

public final class ASMAProduction {
    public final int id;
    public final String title;
    public final int[] authorIDs;
    public final String urlFilePath;

    public ASMAProduction(Production production) {
        this.id = production.id;
        this.title = production.title;
        TreeSet<Integer> authorIDs = new TreeSet<Integer>();
        AuthorNick[] authorNickArray = production.author_nicks;
        int n = production.author_nicks.length;
        int n2 = 0;
        while (n2 < n) {
            AuthorNick authorNick = authorNickArray[n2];
            authorIDs.add(authorNick.releaser.id);
            ++n2;
        }
        this.authorIDs = new int[authorIDs.size()];
        Iterator it = authorIDs.iterator();
        int i = 0;
        while (it.hasNext()) {
            this.authorIDs[i] = (Integer)it.next();
            ++i;
        }
        this.urlFilePath = production.getASMADefaultURLFilePath();
    }

    public String getURL() {
        return "https://demozoo.org/music/" + this.id;
    }

    public String toString() {
        return String.valueOf(this.id) + " - " + this.title + "( " + this.getURL() + " )";
    }
}

