/*
 * Decompiled with CFR 0.152.
 */
package org.atari.asma.demozoo;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.atari.asma.FileInfo;
import org.atari.asma.FileInfoList;
import org.atari.asma.demozoo.ASMAProduction;
import org.atari.asma.demozoo.model.Production;
import org.atari.asma.util.MessageQueue;
import org.atari.asma.util.Serializer;

public class ASMAProductionList {
    private Production[] productions;
    private List<ASMAProduction> productionList;
    private Map<String, ASMAProduction> productionByURLFilePathMap;
    private Map<Integer, ASMAProduction> productionByIDMap;

    public ASMAProductionList(Production[] productions) {
        this.productions = productions;
        this.productionList = new ArrayList<ASMAProduction>();
        this.productionByIDMap = new TreeMap<Integer, ASMAProduction>();
        this.productionByURLFilePathMap = new TreeMap<String, ASMAProduction>();
    }

    public void init() {
        Production[] productionArray = this.productions;
        int n = this.productions.length;
        int n2 = 0;
        while (n2 < n) {
            Production production = productionArray[n2];
            MessageQueue messageQueue = production.getMessageQueue();
            List<String> urlFilePaths = production.getASMAURLFilePaths();
            Set<String> fileExtensions = production.getFileExtensions();
            if (production.download_links.length == 0) {
                messageQueue.sendWarning("DMO-001 - Music has no download link.");
            } else {
                switch (urlFilePaths.size()) {
                    case 0: {
                        if (production.getHardware().equals("ATARI2600") && !fileExtensions.contains("ttt")) {
                            messageQueue.sendInfo("DMO-004 - Atari 2600 is currently not supported by ASMA.");
                            break;
                        }
                        messageQueue.sendError("DMO-002 - Music has no ASMA download link.");
                        break;
                    }
                    case 1: {
                        String urlFilePath = urlFilePaths.get(0);
                        ASMAProduction asmaProduction = new ASMAProduction(production);
                        this.productionList.add(asmaProduction);
                        this.productionByIDMap.put(asmaProduction.id, asmaProduction);
                        ASMAProduction previousProduction = this.productionByURLFilePathMap.put(urlFilePath, asmaProduction);
                        if (previousProduction != null) {
                            String message = "DMO-004: Production " + previousProduction.toString() + " already registered for file path " + previousProduction.urlFilePath + " of production " + asmaProduction.toString();
                            messageQueue.sendError(message);
                            break;
                        }
                        this.productionByURLFilePathMap.put(urlFilePath, asmaProduction);
                        break;
                    }
                    default: {
                        messageQueue.sendError("DMO-003 - Music has more than one ASMA download link.");
                    }
                }
            }
            if (fileExtensions.contains("sap") && !production.hasTag("sap")) {
                messageQueue.sendWarning("DMO-005 - Music has file extension \".sap\", but no tag \"sap\".");
            }
            if (production.hasTag("sap") && !fileExtensions.contains("sap")) {
                messageQueue.sendWarning("DMO-006 - Music has tag \"sap\", but not file extension \".sap\".");
            }
            ++n2;
        }
    }

    public void checkReferences(FileInfoList fileInfoList) {
        TreeMap<String, FileInfo> fileInfoMap = new TreeMap<String, FileInfo>();
        for (FileInfo fileInfo : fileInfoList.getEntries()) {
            fileInfoMap.put(fileInfo.filePath, fileInfo);
        }
        Production[] productionArray = this.productions;
        int n = this.productions.length;
        int n2 = 0;
        while (n2 < n) {
            Production production = productionArray[n2];
            MessageQueue messageQueue = production.getMessageQueue();
            List<String> urlFilePaths = production.getASMAURLFilePaths();
            if (urlFilePaths.size() == 1) {
                String urlFilePath = urlFilePaths.get(0);
                int index = urlFilePath.indexOf(35);
                if (index > 0) {
                    urlFilePath = urlFilePath.substring(0, index);
                }
                if (!fileInfoMap.containsKey(urlFilePath)) {
                    messageQueue.sendError("DMO-006 - Music download URL contains non-existing file path \"" + urlFilePath + "\". Check if ASMA path has changed.");
                }
            }
            ++n2;
        }
    }

    public List<ASMAProduction> getEntries() {
        return this.productionList;
    }

    public ASMAProduction getByID(int id) {
        return this.productionByIDMap.get(id);
    }

    public ASMAProduction getByURLFilePath(String urlFilePath) {
        return this.productionByURLFilePathMap.get(urlFilePath);
    }

    public String getJSONString() {
        ASMAProduction[] productionArray = this.productionList.toArray(new ASMAProduction[this.productionList.size()]);
        return Serializer.serialize(productionArray);
    }
}

