/*
 * Decompiled with CFR 0.152.
 */
package org.atari.asma.demozoo;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.atari.asma.demozoo.RestClient;
import org.atari.asma.demozoo.model.Database;
import org.atari.asma.demozoo.model.Production;
import org.atari.asma.demozoo.model.ProductionsPage;
import org.atari.asma.demozoo.model.ProductionsPageResult;
import org.atari.asma.util.FileUtility;
import org.atari.asma.util.MemoryUtility;
import org.atari.asma.util.MessageQueue;
import org.atari.asma.util.Serializer;
import org.atari.asma.util.StringUtility;

public class Demozoo {
    private static void fetchProductions(Database database, MessageQueue messageQueue) {
        String baseUrlString = "https://demozoo.org/api/v1/productions";
        ArrayList<RestClient.HttpRequest.ParameterValue> parameters = new ArrayList<RestClient.HttpRequest.ParameterValue>();
        parameters.add(new RestClient.HttpRequest.ParameterValue("format", "json"));
        parameters.add(new RestClient.HttpRequest.ParameterValue("supertype", "music"));
        parameters.add(new RestClient.HttpRequest.ParameterValue("platform", 16L));
        parameters.add(new RestClient.HttpRequest.ParameterValue("platform", 54L));
        ProductionsFetcher fetcher = new ProductionsFetcher(messageQueue);
        List<Production> productionList = fetcher.fetchProductions(String.valueOf(baseUrlString) + "?" + RestClient.HttpRequest.getParmetersString(parameters));
        database.productions = productionList.toArray(new Production[productionList.size()]);
    }

    public void importDatabase(File outputFile, MessageQueue messageQueue) {
        Database database = new Database();
        database.updateDateTime = ZonedDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ISO_INSTANT);
        Demozoo.fetchProductions(database, messageQueue);
        messageQueue.sendInfo("Saving to '" + outputFile.getAbsolutePath() + "'.");
        try {
            String content = Serializer.serialize(database);
            FileWriter writer = new FileWriter(outputFile, StandardCharsets.UTF_8);
            writer.write(content);
            writer.close();
            messageQueue.sendInfo("Demozoo database file written with " + MemoryUtility.getRoundedMemorySize(outputFile.length()) + ".");
        }
        catch (IOException ex) {
            messageQueue.sendError(ex.getMessage());
        }
    }

    public Database loadDatabase(File inputFile, MessageQueue messageQueue) {
        String content = FileUtility.readAsString(inputFile);
        Database database = Serializer.deserialize(content, Database.class);
        return database;
    }

    public class PlatformDefinition {
        public static final int ATARI_800 = 16;
        public static final int ATARI_2600 = 54;
    }

    private static class ProductionsFetcher {
        private static final int MAX_PAGES = 1000;
        private MessageQueue messageQueue;
        private long startTimeMillis;
        private List<Production> productionList;

        public ProductionsFetcher(MessageQueue messageQueue) {
            this.messageQueue = messageQueue;
        }

        private boolean fetchProduction(ProductionsPage productionsPage, int resultIndex) {
            RestClient.HttpResponse response;
            ProductionsPageResult productionsPageResult;
            block4: {
                productionsPageResult = productionsPage.results[resultIndex];
                long now = System.currentTimeMillis();
                long milliSecondsSinceStart = now - this.startTimeMillis;
                int productionNumber = this.productionList.size() + 1;
                long milliSecondsToGo = milliSecondsSinceStart / (long)productionNumber * (long)(productionsPage.count - productionNumber);
                if (productionNumber % 10 == 0) {
                    this.messageQueue.sendInfo("Fetching production " + productionNumber + " of " + productionsPage.count + " from " + productionsPageResult.url + " (" + StringUtility.getDurationString(milliSecondsSinceStart) + " until now, " + StringUtility.getDurationString(milliSecondsToGo) + " to go)");
                }
                try {
                    response = RestClient.sendGetRequest(productionsPageResult.url);
                    if (!response.isSuccess()) break block4;
                    Production production = Serializer.deserialize(response.content, Production.class);
                    this.productionList.add(production);
                    return true;
                }
                catch (IOException ex) {
                    this.messageQueue.sendError("Fetch error for '" + productionsPageResult.url + "': " + ex.getMessage());
                    return false;
                }
            }
            this.messageQueue.sendError("Fetch error for '" + productionsPageResult.url + "': " + response.status + " - " + response.content);
            return false;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private ProductionsPage fetchPage(String url, List<Production> productionList) {
            try {
                RestClient.HttpResponse response = RestClient.sendGetRequest(url);
                ProductionsPage productionsPage = Serializer.deserialize(response.content, ProductionsPage.class);
                int i = 0;
                while (true) {
                    if (i >= productionsPage.results.length) {
                        return productionsPage;
                    }
                    if (!this.fetchProduction(productionsPage, i)) {
                        return null;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ++i;
                }
            }
            catch (IOException ex) {
                this.messageQueue.sendError(ex.getMessage());
                return null;
            }
        }

        public List<Production> fetchProductions(String url) {
            int pageNumber = 0;
            this.startTimeMillis = System.currentTimeMillis();
            this.productionList = new ArrayList<Production>();
            do {
                if (++pageNumber <= 1000) {
                    this.messageQueue.sendInfo("Fetching page " + pageNumber + " from " + url);
                    ProductionsPage page = this.fetchPage(url, this.productionList);
                    if (page == null) continue;
                    url = page.next;
                    continue;
                }
                url = null;
            } while (url != null && !url.isEmpty());
            return this.productionList;
        }
    }
}

