/*
 * Decompiled with CFR 0.152.
 */
package org.atari.asma.demozoo;

import java.io.File;
import org.atari.asma.demozoo.Demozoo;
import org.atari.asma.util.MessageQueue;
import org.atari.asma.util.MessageQueueFactory;

public class DemozooImporter {
    public static void main(String[] args) {
        System.exit(new DemozooImporter().run(args));
    }

    private DemozooImporter() {
    }

    private int run(String[] args) {
        MessageQueue messageQueue = MessageQueueFactory.createSystemInstance();
        if (args.length != 1) {
            messageQueue.sendInfo("Usage: DemozooImporter <trunk/asma folder>");
            return 0;
        }
        String sourceFolderPath = args[0];
        File sourceFolder = new File(sourceFolderPath);
        File databaseFile = new File(sourceFolder, "Docs/Demozoo-Database.json");
        Demozoo demozoo = new Demozoo();
        messageQueue.sendInfo("Fetching Demozoo database to '" + databaseFile.getPath() + "'.");
        if (!databaseFile.exists()) {
            messageQueue.sendError("Output file '" + databaseFile.getPath() + "' does not exist.");
            return 1;
        }
        if (!databaseFile.canWrite()) {
            messageQueue.sendError("Output file '" + databaseFile.getPath() + "' is not writeable.");
            return 1;
        }
        demozoo.importDatabase(databaseFile, messageQueue);
        messageQueue.printSummary();
        return 0;
    }
}

