/*
 * Decompiled with CFR 0.152.
 */
package org.atari.asma.demozoo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;

public class RestClient {
    public static HttpResponse sendGetRequest(String urlString) throws IOException {
        HttpURLConnection con = null;
        HttpResponse response = new HttpResponse();
        try {
            String inputLine;
            URL url = new URL(urlString);
            con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            con.setConnectTimeout(5000);
            con.setReadTimeout(5000);
            int status = con.getResponseCode();
            InputStreamReader streamReader = new InputStreamReader(con.getInputStream());
            BufferedReader in = new BufferedReader(streamReader);
            StringBuffer content = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                content.append(inputLine);
            }
            in.close();
            con.disconnect();
            response.status = status;
            response.content = content.toString();
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
        return response;
    }

    public static class HttpRequest {
        private HttpRequest() {
        }

        public static String getParmetersString(List<ParameterValue> parameterValues) {
            StringBuilder result = new StringBuilder();
            try {
                int i = 0;
                while (i < parameterValues.size()) {
                    ParameterValue entry = parameterValues.get(i);
                    result.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
                    result.append("=");
                    result.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
                    if (i < parameterValues.size() - 1) {
                        result.append("&");
                    }
                    ++i;
                }
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            return result.toString();
        }

        public static class ParameterValue {
            private final String key;
            private final String value;

            public ParameterValue(String key, String value) {
                this.key = key;
                this.value = value;
            }

            public ParameterValue(String key, long value) {
                this(key, String.valueOf(value));
            }

            public String getKey() {
                return this.key;
            }

            public String getValue() {
                return this.value;
            }
        }
    }

    public static final class HttpResponse {
        public int status;
        public String content;

        public boolean isSuccess() {
            return this.status >= 200 && this.status <= 299;
        }
    }
}

