/*
 * Decompiled with CFR 0.152.
 */
package org.atari.asma.demozoo.model;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.atari.asma.demozoo.model.AuthorNick;
import org.atari.asma.demozoo.model.Link;
import org.atari.asma.demozoo.model.Platform;
import org.atari.asma.demozoo.model.ProductionType;
import org.atari.asma.util.FileUtility;
import org.atari.asma.util.MessageQueue;
import org.atari.asma.util.StringUtility;

public final class Production {
    public String url;
    public String demozoo_url;
    public int id;
    public String title = "";
    public AuthorNick[] author_nicks;
    public String release_date;
    public String supertype;
    public Platform[] platforms;
    public ProductionType[] types;
    public Link[] download_links;
    public String[] tags;
    private transient MessageQueue messageQueue = new MessageQueue();
    private static final String ASMA_URL_PREFIX = "https://asma.atari.org/asma/";

    public MessageQueue getMessageQueue() {
        return this.messageQueue;
    }

    public List<String> getASMAURLFilePaths() {
        ArrayList<String> result = new ArrayList<String>(2);
        Link[] linkArray = this.download_links;
        int n = this.download_links.length;
        int n2 = 0;
        while (n2 < n) {
            Link link = linkArray[n2];
            if (link.link_class.equals("BaseUrl") && link.url.startsWith(ASMA_URL_PREFIX)) {
                result.add(link.url.substring(ASMA_URL_PREFIX.length()));
            }
            ++n2;
        }
        return result;
    }

    public String getASMADefaultURLFilePath() {
        List<String> urlFilePaths = this.getASMAURLFilePaths();
        if (urlFilePaths.size() == 1) {
            return urlFilePaths.get(0);
        }
        return "";
    }

    public Set<String> getFileExtensions() {
        TreeSet<String> set = new TreeSet<String>();
        Link[] linkArray = this.download_links;
        int n = this.download_links.length;
        int n2 = 0;
        while (n2 < n) {
            Link link = linkArray[n2];
            try {
                URI uri = new URI(link.url);
                String fileExtension = FileUtility.getFileExtension(uri.getPath());
                if (fileExtension.startsWith(".")) {
                    fileExtension = fileExtension.substring(1);
                }
                fileExtension = fileExtension.toLowerCase();
                set.add(fileExtension);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            ++n2;
        }
        return set;
    }

    public String getHardware() {
        Platform[] platformArray = this.platforms;
        int n = this.platforms.length;
        int n2 = 0;
        while (n2 < n) {
            Platform platform = platformArray[n2];
            if (platform.id == 16) {
                return "ATARI800";
            }
            if (platform.id == 54) {
                return "ATARI2600";
            }
            ++n2;
        }
        return "";
    }

    public boolean hasTag(String tag) {
        return StringUtility.hasElement(this.tags, tag);
    }

    public String getTags() {
        return StringUtility.toSortedString(this.tags);
    }
}

