/*
 * Decompiled with CFR 0.152.
 */
package org.atari.asma.sap;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import net.sf.asap.ASAP;
import net.sf.asap.ASAPArgumentException;
import net.sf.asap.ASAPConversionException;
import net.sf.asap.ASAPFormatException;
import net.sf.asap.ASAPIOException;
import net.sf.asap.ASAPInfo;
import net.sf.asap.ASAPWriter;
import org.atari.asma.sap.ASAPFile;
import org.atari.asma.sap.ByteUtility;
import org.atari.asma.sap.SAPFileProcessor;
import org.atari.asma.sap.SAPTags;
import org.atari.asma.sap.Segment;
import org.atari.asma.sap.SegmentList;
import org.atari.asma.sap.SegmentListLogic;
import org.atari.asma.sap.player.Player;
import org.atari.asma.sap.player.PlayerFactory;
import org.atari.asma.util.FileUtility;
import org.atari.asma.util.MessageQueue;

public class ASAPFileLogic {
    private SegmentListLogic segmentListLogic = new SegmentListLogic();

    public ASAPFile loadSAPFile(File file, MessageQueue messageQueue) {
        return this.loadSAPFile(file.getName(), FileUtility.readAsByteArray(file), messageQueue);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ASAPFile loadSAPFile(String fileName, byte[] content, MessageQueue messageQueue) {
        if (content.length == 0) {
            messageQueue.sendError("File '" + fileName + "' is empty");
            return null;
        }
        int index = 0;
        boolean endOfHeader = false;
        StringBuilder headerBuilder = new StringBuilder();
        while (index < content.length && !endOfHeader) {
            int b = content[index] & 0xFF;
            if (b == 255) {
                endOfHeader = true;
                break;
            }
            if (b == 13) {
                if (index < content.length - 1) {
                    b = content[index + 1];
                    if (b != 10) {
                        messageQueue.sendError("Invalid character " + ByteUtility.getCharForByte(b) + " after carriage return at index. Line feed expected.");
                        return null;
                    }
                    headerBuilder.append("\n");
                    ++index;
                } else {
                    messageQueue.sendError("Missing line feed after carriage return at index " + ByteUtility.getIndexString(index) + ".");
                }
            } else {
                char c = (char)(b & 0xFF);
                if ("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789 !\"#$%&'()*+,-./:;<=>?@[\\]^_|".indexOf(c) == -1) {
                    messageQueue.sendError("Invalid non-ATASCII character " + ByteUtility.getCharForByte(b) + " at index " + ByteUtility.getIndexString(index) + ".");
                    return null;
                }
                headerBuilder.append(c);
            }
            ++index;
        }
        if (!endOfHeader) {
            messageQueue.sendError("Invalid file structure.");
            return null;
        }
        String header = headerBuilder.toString();
        if (!header.startsWith("SAP\n")) {
            messageQueue.sendError("Header does not start with 'SAP' line.");
            return null;
        }
        String[] lines = header.split("\n");
        List<String> tags = SAPTags.getTags();
        TreeSet<String> foundTagSet = new TreeSet<String>();
        int tagIndex = 0;
        int lineIndex = 1;
        while (lineIndex < lines.length) {
            String line = lines[lineIndex];
            int spaceIndex = line.indexOf(32);
            if (spaceIndex >= 0) {
                line = line.substring(0, spaceIndex);
            }
            if (line.length() != 0) {
                String foundTag = line;
                foundTagSet.add(foundTag);
                if (!tags.contains(foundTag)) {
                    messageQueue.sendError("Undefined tag '" + foundTag + "' found.");
                    return null;
                }
                boolean ok = false;
                while (tagIndex < tags.size()) {
                    String tag = tags.get(tagIndex);
                    if (tag.equals(foundTag)) {
                        ok = true;
                        break;
                    }
                    ++tagIndex;
                }
                if (!ok) {
                    messageQueue.sendWarning("Found tag " + foundTag + " does not fit to the recommended tag sequece '" + tags.toString() + "'.");
                    return null;
                }
            }
            ++lineIndex;
        }
        if (!foundTagSet.contains("AUTHOR")) {
            messageQueue.sendWarning("Stronly recommended tag 'AUTHOR' missing");
            return null;
        }
        if (!foundTagSet.contains("NAME")) {
            messageQueue.sendWarning("Stronly recommended tag 'NAME' missing");
            return null;
        }
        if (!foundTagSet.contains("DATE")) {
            messageQueue.sendWarning("Stronly recommended tag 'DATE' missing");
            return null;
        }
        if (index + 6 >= content.length) {
            messageQueue.sendError("Invalid binary segment at index " + ByteUtility.getIndexString(index) + ".");
            return null;
        }
        ASAPFile sapFile = new ASAPFile();
        sapFile.content = content;
        if (!this.segmentListLogic.loadSegmentList(sapFile.segmentList, content, index, messageQueue)) {
            return null;
        }
        ASAP asap = new ASAP();
        try {
            asap.load(fileName, content, content.length);
        }
        catch (ASAPFormatException ex) {
            messageQueue.sendError("Invalid SAP file. " + ex.getMessage());
            return null;
        }
        sapFile.setASAPInfo(asap.getInfo());
        return sapFile;
    }

    public ASAPFile loadOriginalModuleFile(File file, MessageQueue messageQueue) {
        return this.loadOriginalModuleFile(file.getName(), FileUtility.readAsByteArray(file), messageQueue);
    }

    public ASAPFile loadOriginalModuleFile(String fileName, byte[] content, MessageQueue messageQueue) {
        ASAP asap = new ASAP();
        try {
            asap.load(fileName, content, content.length);
        }
        catch (ASAPFormatException ex) {
            messageQueue.sendError("Invalid ASAP file. " + ex.getMessage());
            return null;
        }
        String tempSAPFileName = FileUtility.changeFileExtension(new File(fileName), ".sap").getName();
        MemoryASAPWriter asapWriter = new MemoryASAPWriter();
        try {
            ASAPInfo asapInfo = asap.getInfo();
            asapWriter.write(tempSAPFileName, asapInfo, content, content.length, false);
        }
        catch (ASAPConversionException ex) {
            messageQueue.sendError("Cannot save SAP file. " + ex.getMessage());
            return null;
        }
        catch (ASAPIOException ex) {
            messageQueue.sendError("Cannot save SAP file. " + ex.getMessage());
            return null;
        }
        if (asapWriter.fileMap.size() != 1) {
            messageQueue.sendError("File could not be converted to SAP format.");
            return null;
        }
        ASAPFile sapFile = this.loadSAPFile(tempSAPFileName, asapWriter.fileMap.get(tempSAPFileName), messageQueue);
        return sapFile;
    }

    public boolean saveSAPFile(File file, ASAPFile asapFile, MessageQueue messageQueue) {
        MemoryASAPWriter asapWriter = new MemoryASAPWriter();
        ASAPInfo asapInfo = asapFile.getASAPInfo();
        try {
            asapInfo.setAuthor(asapFile.getAuthor());
        }
        catch (ASAPArgumentException ex) {
            messageQueue.sendError("Cannot set author. " + ex.getMessage());
        }
        try {
            asapInfo.setTitle(asapFile.getTitle());
        }
        catch (ASAPArgumentException ex) {
            messageQueue.sendError("Cannot set title. " + ex.getMessage());
        }
        try {
            asapInfo.setDate(asapFile.getDate());
        }
        catch (ASAPArgumentException ex) {
            messageQueue.sendError("Cannot set date. " + ex.getMessage());
        }
        if (messageQueue.getErrorCount() > 0L) {
            return false;
        }
        try {
            asapWriter.write(file.getAbsolutePath(), asapInfo, asapFile.content, asapFile.content.length, false);
            byte[] content = asapWriter.fileMap.get(file.getAbsolutePath());
            if (content == null) {
                throw new IOException("Could not write SAP file to memory.");
            }
            Files.write(file.toPath(), content, StandardOpenOption.CREATE);
        }
        catch (ASAPConversionException ex) {
            messageQueue.sendError("Cannot save SAP file. " + ex.getMessage());
            return false;
        }
        catch (ASAPIOException ex) {
            messageQueue.sendError("Cannot save SAP file. " + ex.getMessage());
            return false;
        }
        catch (IOException ex) {
            messageQueue.sendError("Cannot save SAP file. " + ex.getMessage());
            return false;
        }
        return true;
    }

    public ASAPFile loadXEXFile(SAPFileProcessor fileProcessor, File inputFile, PrintWriter header, MessageQueue messageQueue) {
        Player player;
        SegmentList segmentList = new SegmentList();
        if (!this.segmentListLogic.loadSegmentList(segmentList, inputFile, messageQueue)) {
            return null;
        }
        header.println("XEX");
        PlayerFactory playerFactory = new PlayerFactory();
        List<Player> players = playerFactory.getMatchingPlayers(segmentList);
        if (players.isEmpty()) {
            header.println("PLAYER UNKNOWN");
        } else {
            for (Player player2 : players) {
                header.println("PLAYER \"" + player2.getName() + "\"");
                header.println();
                ArrayList<String> texts = new ArrayList<String>();
                player2.getTexts(segmentList, texts);
                for (String text : texts) {
                    header.println(text);
                }
            }
        }
        ASAPFile asapFile = new ASAPFile();
        asapFile.segmentList.getEntries().addAll(segmentList.getEntries());
        if (players.isEmpty()) {
            int i = 0;
            while (i < segmentList.size()) {
                Segment segment = asapFile.segmentList.get(i);
                messageQueue.sendInfo("Scanning segment " + i + " for modules.");
                ASAPFileLogic.scanSegment(fileProcessor, inputFile, segment, header, messageQueue);
                ++i;
            }
        } else if (players.size() == 1 && (player = players.get(0)).fillSAPFile(asapFile, segmentList, messageQueue)) {
            messageQueue.sendInfo("Convertered " + player.getName() + " file to SAP format.");
        }
        return asapFile;
    }

    private static List<RMTEntry> findRMTEntries(Segment segment) {
        ArrayList<RMTEntry> result = new ArrayList<RMTEntry>();
        int i = 0;
        while (i < segment.getLength() - 4) {
            char c1 = (char)segment.content[i];
            char c2 = (char)segment.content[i + 1];
            char c3 = (char)segment.content[i + 2];
            char c4 = (char)segment.content[i + 3];
            if (c1 == 'R' && c2 == 'M' && c3 == 'T' && (c4 == '4' || c4 == '8')) {
                RMTEntry entry = new RMTEntry();
                entry.offset = i;
                entry.type = String.valueOf(String.valueOf(c1)) + String.valueOf(c2) + String.valueOf(c3) + String.valueOf(c4);
                result.add(entry);
            }
            ++i;
        }
        return result;
    }

    private static void scanSegment(SAPFileProcessor fileProcessor, File inputFile, Segment segment, PrintWriter header, MessageQueue messageQueue) {
        List<RMTEntry> rmtOffsets = ASAPFileLogic.findRMTEntries(segment);
        int i = 0;
        while (i < rmtOffsets.size()) {
            RMTEntry entry = rmtOffsets.get(i);
            int startAddress = segment.startAddress + entry.offset;
            int endAddress = i < rmtOffsets.size() - 1 ? segment.startAddress + rmtOffsets.get((int)(i + 1)).offset - 1 : segment.endAddress;
            int length = endAddress - startAddress + 1;
            String startAddressString = ByteUtility.getWordHexString(startAddress);
            String endAddressString = ByteUtility.getWordHexString(endAddress);
            messageQueue.sendInfo("Found " + entry.type + " at $" + startAddressString + " - $" + endAddressString + ".");
            byte[] rmtContent = new byte[6 + length];
            rmtContent[0] = -1;
            rmtContent[1] = -1;
            rmtContent[2] = (byte)(startAddress & 0xFF);
            rmtContent[3] = (byte)(startAddress >> 8);
            rmtContent[4] = (byte)(endAddress & 0xFF);
            rmtContent[5] = (byte)(endAddress >> 8);
            System.arraycopy(segment.content, entry.offset, rmtContent, 6, length);
            File rmtFile = FileUtility.changeFileExtension(inputFile, "");
            rmtFile = new File(String.valueOf(rmtFile.getAbsolutePath()) + "-$" + startAddressString + ".rmt");
            try {
                Files.write(rmtFile.toPath(), rmtContent, StandardOpenOption.CREATE);
                messageQueue.sendInfo("Opening " + rmtFile.getAbsolutePath() + " in separate window.");
                fileProcessor.processFile(rmtFile);
            }
            catch (IOException e) {
                messageQueue.sendError(e.getMessage());
            }
            ++i;
        }
    }

    private static final class MemoryASAPWriter
    extends ASAPWriter {
        public Map<String, byte[]> fileMap = new TreeMap<String, byte[]>();

        private MemoryASAPWriter() {
        }

        protected void save(String filename, byte[] buffer, int offset, int length) throws ASAPIOException {
            byte[] content = new byte[length];
            System.arraycopy(buffer, offset, content, 0, length);
            this.fileMap.put(filename, content);
        }
    }

    private static class RMTEntry {
        int offset;
        String type;

        private RMTEntry() {
        }
    }
}

