/*
 * Decompiled with CFR 0.152.
 */
package org.atari.asma.sap;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.atari.asma.sap.ASAPFile;

public class ASAPPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private int row;
    public JLabel authorLabel;
    public JTextField authorField;
    public JLabel nameLabel;
    public JTextField nameField;
    public JLabel dateLabel;
    public JTextField dateField;

    private void addLabel(JLabel label) {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets.top = 5;
        c.insets.right = 5;
        c.gridx = 0;
        c.gridy = this.row;
        this.add((Component)label, c);
    }

    private void addTextField(JTextField textField) {
        textField.setBorder(null);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets.top = 5;
        c.insets.right = 5;
        c.gridx = 1;
        c.gridy = this.row++;
        c.weightx = 1.0;
        this.add((Component)textField, c);
    }

    public ASAPPanel() {
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        this.authorLabel = new JLabel();
        this.authorLabel.setText("Author");
        this.addLabel(this.authorLabel);
        this.authorField = new JTextField();
        this.addTextField(this.authorField);
        this.nameLabel = new JLabel();
        this.nameLabel.setText("Title");
        this.addLabel(this.nameLabel);
        this.nameField = new JTextField();
        this.addTextField(this.nameField);
        this.dateLabel = new JLabel();
        this.dateLabel.setText("Date");
        this.addLabel(this.dateLabel);
        this.dateField = new JTextField();
        this.addTextField(this.dateField);
        JLabel filler = new JLabel();
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = this.row;
        c.fill = 2;
        c.weighty = 1.0;
        this.add((Component)filler, c);
        this.setEditable(false);
    }

    public void setEditable(boolean editable) {
        this.authorField.setEditable(editable);
        this.nameField.setEditable(editable);
        this.dateField.setEditable(editable);
    }

    public void dataToUI(ASAPFile asapFile, File outputFile) {
        this.authorField.setText(asapFile.getAuthor());
        this.nameField.setText(asapFile.getTitle());
        this.dateField.setText(asapFile.getDate());
        this.setEditable(outputFile != null);
    }

    public void dataFromUI(ASAPFile asapFile) {
        asapFile.setAuthor(this.authorField.getText());
        asapFile.setTitle(this.nameField.getText());
        asapFile.setDate(this.dateField.getText());
    }
}

