/*
 * Decompiled with CFR 0.152.
 */
package org.atari.asma.sap;

import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class FilePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public JLabel filePathLabel;
    public JTextField filePathField;
    public JLabel fileStatusLabel;
    public JLabel fileSizeLabel;
    public JLabel fileDateLabel;
    public JButton playButton;

    public FilePanel() {
        Border border = BorderFactory.createEmptyBorder(1, 5, 1, 5);
        BoxLayout layout = new BoxLayout(this, 2);
        this.setLayout(layout);
        this.filePathLabel = new JLabel();
        this.filePathLabel.setBorder(border);
        this.add(this.filePathLabel);
        this.filePathField = new JTextField();
        this.filePathField.setBorder(border);
        this.add(this.filePathField);
        this.fileStatusLabel = new JLabel();
        this.fileStatusLabel.setBorder(border);
        this.add(this.fileStatusLabel);
        this.fileSizeLabel = new JLabel();
        this.fileSizeLabel.setBorder(border);
        this.add(this.fileSizeLabel);
        this.fileDateLabel = new JLabel();
        this.fileDateLabel.setBorder(border);
        this.add(this.fileDateLabel);
        this.playButton = new JButton("Play");
        this.add(this.playButton);
        this.playButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.open(new File(FilePanel.this.filePathField.getText()));
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.setEditable(false);
    }

    public void setEditable(boolean editable) {
        this.filePathField.setEditable(editable);
    }

    public void setFile(File file) {
        SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        if (file != null) {
            this.filePathField.setText(file.getAbsolutePath());
            if (file.exists()) {
                if (file.isFile()) {
                    this.fileStatusLabel.setText("Exists");
                    this.fileSizeLabel.setText(String.valueOf(String.valueOf(file.length())) + " b");
                    this.fileDateLabel.setText(format.format(new Date(file.lastModified())));
                    this.playButton.setEnabled(true);
                } else {
                    this.fileStatusLabel.setText("Directory");
                    this.fileSizeLabel.setText("");
                    this.fileDateLabel.setText("");
                    this.playButton.setEnabled(false);
                }
            } else {
                this.fileStatusLabel.setText("New");
                this.playButton.setEnabled(false);
            }
        } else {
            this.filePathField.setText("");
            this.fileStatusLabel.setText("");
            this.fileSizeLabel.setText("");
            this.fileDateLabel.setText("");
            this.playButton.setEnabled(false);
        }
    }
}

