/*
 * Decompiled with CFR 0.152.
 */
package org.atari.asma.sap;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import org.atari.asma.sap.ASAPFile;
import org.atari.asma.sap.ASAPFileLogic;
import org.atari.asma.sap.ASAPPanel;
import org.atari.asma.sap.FilePanel;
import org.atari.asma.sap.SAPFileProcessor;
import org.atari.asma.util.FileDrop;
import org.atari.asma.util.FileUtility;
import org.atari.asma.util.MessageQueue;

class SAPFileDialog {
    private static String TITLE = "SAP File Editor";
    private SAPFileProcessor fileProcessor;
    private ASAPFileLogic asapFileLogic;
    private MessageQueue messageQueue;
    private JFrame frame;
    private JButton openButton;
    private JButton saveButton;
    private FilePanel inputFilePanel;
    private FilePanel outputFilePanel;
    private JTextArea inputFileStructureTextArea;
    private JTextArea analysisTextArea;
    private ASAPPanel asapPanel;
    private JTextArea messageTextArea;
    private JFileChooser fileChooser;
    private File inputFile;
    private File outputFile;
    private StringBuilder header;
    private ASAPFile asapFile;

    public SAPFileDialog(final SAPFileProcessor editor) {
        this.fileProcessor = editor;
        this.asapFileLogic = new ASAPFileLogic();
        this.messageQueue = new MessageQueue();
        this.inputFile = new File("");
        this.outputFile = null;
        this.header = new StringBuilder();
        this.asapFile = new ASAPFile();
        this.frame = new JFrame();
        this.frame.setTitle(TITLE);
        this.openButton = new JButton("Open");
        this.openButton.setToolTipText("Open a new input file.");
        this.openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SAPFileDialog.this.performOpen();
            }
        });
        SaveAction saveAction = new SaveAction("Save", null, "Save the current output file", null);
        this.saveButton = new JButton(saveAction);
        JToolBar toolbar = new JToolBar();
        toolbar.add(this.openButton);
        toolbar.add(this.saveButton);
        this.frame.setLayout(new BorderLayout());
        JPanel filePanel = new JPanel();
        filePanel.setLayout(new BorderLayout());
        this.inputFilePanel = new FilePanel();
        this.inputFilePanel.filePathLabel.setText("Input File");
        this.outputFilePanel = new FilePanel();
        this.outputFilePanel.filePathLabel.setText("Output File");
        JPanel contentPanel = new JPanel();
        GridLayout layout = new GridLayout();
        layout.setColumns(2);
        contentPanel.setLayout(layout);
        EmptyBorder border = new EmptyBorder(5, 5, 5, 5);
        this.inputFileStructureTextArea = new JTextArea();
        this.inputFileStructureTextArea.setBorder(border);
        this.inputFileStructureTextArea.setEditable(false);
        this.inputFileStructureTextArea.setBackground(new Color(204, 204, 204));
        contentPanel.add(this.inputFileStructureTextArea);
        this.analysisTextArea = new JTextArea();
        this.analysisTextArea.setBorder(border);
        this.analysisTextArea.setEditable(false);
        this.analysisTextArea.setBackground(new Color(224, 224, 224));
        contentPanel.add(this.analysisTextArea);
        this.asapPanel = new ASAPPanel();
        this.asapPanel.setBackground(this.inputFileStructureTextArea.getBackground());
        contentPanel.add(this.asapPanel);
        JPanel filePathsPanel = new JPanel();
        filePathsPanel.setLayout(new BorderLayout());
        filePathsPanel.add((Component)this.inputFilePanel, "North");
        filePathsPanel.add((Component)this.outputFilePanel, "South");
        filePanel.add((Component)filePathsPanel, "North");
        filePanel.add((Component)contentPanel, "Center");
        this.frame.add((Component)toolbar, "North");
        this.frame.add((Component)filePanel, "Center");
        this.messageTextArea = new JTextArea();
        this.messageTextArea.setBorder(border);
        this.messageTextArea.setEditable(false);
        this.messageTextArea.setBackground(this.frame.getBackground());
        this.frame.add((Component)this.messageTextArea, "South");
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                editor.closeFile(SAPFileDialog.this.inputFile);
            }
        });
        new FileDrop(this.frame, new FileDrop.Listener(){

            @Override
            public void filesDropped(File[] files) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    editor.processFile(file);
                    ++n2;
                }
            }
        });
        this.fileChooser = new JFileChooser();
        this.dataToUI();
        this.frame.pack();
        this.frame.setVisible(false);
    }

    public JFrame getFrame() {
        return this.frame;
    }

    private void dataToUI() {
        StringBuilder title = new StringBuilder(TITLE).append(" - ").append(this.inputFile.getName()).append(" - ");
        title.append(this.asapFile.getTitle()).append(" by ").append(this.asapFile.getAuthor());
        this.saveButton.setEnabled(this.outputFile != null && this.asapFile.getASAPInfo() != null);
        this.frame.setTitle(title.toString());
        this.inputFilePanel.setFile(this.inputFile);
        this.outputFilePanel.setFile(this.outputFile);
        this.analysisTextArea.setText(this.header.toString());
        this.inputFileStructureTextArea.setText(this.asapFile.segmentList.toString());
        this.asapPanel.dataToUI(this.asapFile, this.outputFile);
        this.asapPanel.requestFocus();
        this.displayMessageQueue();
    }

    private void dataFromUI() {
        this.messageQueue.clear();
        this.asapPanel.dataFromUI(this.asapFile);
    }

    public void show(File inputFile) {
        ASAPFile newASAPFile = null;
        this.inputFile = inputFile;
        this.outputFile = null;
        this.header.setLength(0);
        this.messageQueue.sendInfo("Reading '" + inputFile.getAbsolutePath() + "'.");
        String fileExtension = FileUtility.getFileExtension(inputFile.getName()).toLowerCase();
        if (fileExtension.equals(".sap")) {
            newASAPFile = this.asapFileLogic.loadSAPFile(inputFile, this.messageQueue);
            this.outputFile = inputFile;
        } else if (ASAPFile.isOriginalModuleFileExtension(fileExtension)) {
            newASAPFile = this.asapFileLogic.loadOriginalModuleFile(inputFile, this.messageQueue);
            if (newASAPFile != null) {
                this.outputFile = FileUtility.changeFileExtension(inputFile, ".sap");
                this.messageQueue.sendInfo("Converted ASAP compatible file '" + inputFile.getName() + "' to '" + this.outputFile.getName() + "'.");
                if (this.outputFile.exists()) {
                    this.messageQueue.sendWarning("Be careful when saving, the target file already exists.");
                }
            }
        } else if (fileExtension.equals(".xex")) {
            StringWriter writer = new StringWriter();
            newASAPFile = this.asapFileLogic.loadXEXFile(this.fileProcessor, inputFile, new PrintWriter(writer), this.messageQueue);
            this.header.append(writer.toString());
            this.outputFile = this.asapFile != null ? FileUtility.changeFileExtension(inputFile, ".sap") : null;
        } else {
            this.messageQueue.sendError("Unsupported file extension or file type.");
        }
        if (newASAPFile != null) {
            this.asapFile = newASAPFile;
        } else {
            this.messageQueue.sendInfo("Error reading '" + inputFile.getAbsolutePath() + "'. See above.");
        }
        this.dataToUI();
        if (!this.frame.isVisible()) {
            this.frame.pack();
            this.frame.setVisible(true);
        }
    }

    private void displayMessageQueue() {
        StringBuilder builder = new StringBuilder();
        List<MessageQueue.Entry> entries = this.messageQueue.getEntries();
        for (MessageQueue.Entry entry : entries) {
            builder.append(entry.getType().toString()).append(" : ").append(entry.getMessage());
            builder.append("\n");
        }
        this.messageTextArea.setText(builder.toString());
    }

    private void performOpen() {
        this.dataFromUI();
        this.fileChooser.setCurrentDirectory(this.inputFile.getParentFile());
        this.fileChooser.setFileSelectionMode(0);
        this.fileChooser.setMultiSelectionEnabled(false);
        if (this.fileChooser.showOpenDialog(this.frame) == 0) {
            this.fileProcessor.processFile(this.fileChooser.getSelectedFile());
        }
        this.dataToUI();
    }

    private void performSave() {
        this.dataFromUI();
        if (this.asapFileLogic.saveSAPFile(this.outputFile, this.asapFile, this.messageQueue)) {
            this.messageQueue.sendInfo("SAP file '" + this.outputFile.getAbsolutePath() + "' saved.");
            this.outputFilePanel.setFile(this.outputFile);
        }
        this.dataToUI();
    }

    private final class SaveAction
    extends AbstractAction {
        public SaveAction(String text, ImageIcon icon, String description, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", description);
            this.putValue("MnemonicKey", mnemonic);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SAPFileDialog.this.performSave();
        }
    }
}

