/*
 * Decompiled with CFR 0.152.
 */
package org.atari.asma.sap;

import java.io.File;
import java.io.FileFilter;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.atari.asma.sap.ASAPFile;
import org.atari.asma.sap.ASAPFileLogic;
import org.atari.asma.sap.SAPFileDialog;
import org.atari.asma.sap.SAPFileProcessor;
import org.atari.asma.util.BufferedMessageQueue;
import org.atari.asma.util.FileUtility;
import org.atari.asma.util.MessageQueue;
import org.atari.asma.util.MessageQueueFactory;

public class SAPFileEditor
implements SAPFileProcessor {
    private MessageQueue messageQueue = MessageQueueFactory.createSystemInstance();
    private ASAPFileLogic sapFileLogic = new ASAPFileLogic();
    private Map<String, SAPFileDialog> sapFileDialogMap = new TreeMap<String, SAPFileDialog>();

    private SAPFileEditor() {
    }

    public static void main(String[] args) {
        SAPFileEditor instance = new SAPFileEditor();
        instance.run(args);
    }

    private void run(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        File[] files = new File[args.length];
        int i = 0;
        while (i < args.length) {
            files[i] = new File(args[i]);
            ++i;
        }
        if (files.length == 0) {
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle("SAPFileEditor - Select files");
            chooser.setFileSelectionMode(0);
            chooser.setMultiSelectionEnabled(true);
            int returnVal = chooser.showOpenDialog(null);
            if (returnVal == 0) {
                files = chooser.getSelectedFiles();
            }
        }
        this.runFilesOrFolders(files);
    }

    private void runFilesOrFolders(File[] files) {
        this.messageQueue.clear();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            try {
                if (file.isDirectory()) {
                    this.processFolder(file);
                } else {
                    this.processFile(file);
                }
            }
            catch (Exception ex) {
                this.messageQueue.sendError(ex.getMessage());
                ex.printStackTrace();
            }
            ++n2;
        }
        this.messageQueue.printSummary();
    }

    @Override
    public void processFile(File inputFile) {
        String path = inputFile.getAbsolutePath();
        SAPFileDialog dialog = this.sapFileDialogMap.get(path);
        if (dialog == null) {
            dialog = new SAPFileDialog(this);
            this.sapFileDialogMap.put(path, dialog);
        }
        dialog.show(inputFile);
    }

    @Override
    public void closeFile(File inputFile) {
        String path = inputFile.getAbsolutePath();
        this.sapFileDialogMap.remove(path);
        if (this.sapFileDialogMap.isEmpty()) {
            System.exit(0);
        }
    }

    @Override
    public void processFolder(File folder) {
        this.messageQueue.sendInfo("Scanning " + folder.getAbsolutePath());
        List<File> fileList = FileUtility.getRecursiveFileList(folder, new FileFilter(){

            @Override
            public boolean accept(File file) {
                String fileName = file.getName().toLowerCase();
                return fileName.endsWith(".sap");
            }
        });
        int totalCount = fileList.size();
        this.messageQueue.sendInfo(String.valueOf(totalCount) + " files found.");
        AtomicInteger count = new AtomicInteger();
        int blockSize = 100;
        fileList.parallelStream().forEach(file -> {
            BufferedMessageQueue localMessageQueue;
            ASAPFile sapFile;
            if (count.incrementAndGet() % 100 == 0) {
                MessageQueue messageQueue = this.messageQueue;
                synchronized (messageQueue) {
                    this.messageQueue.sendInfo(count + " files processed.");
                }
            }
            if ((sapFile = this.sapFileLogic.loadSAPFile((File)file, localMessageQueue = new BufferedMessageQueue(this.messageQueue))) == null) {
                this.messageQueue.sendInfo("Error reading '" + file.getAbsolutePath() + "'. See above.");
            }
            localMessageQueue.flush();
        });
        this.messageQueue.sendInfo("All " + fileList.size() + " files processed.");
    }
}

