/*
 * Decompiled with CFR 0.152.
 */
package org.atari.asma.sap;

import java.nio.charset.StandardCharsets;
import java.util.zip.CRC32;
import org.atari.asma.RMTFile;
import org.atari.asma.sap.ByteUtility;

public class Segment {
    public boolean header;
    public int segment;
    public int startAddress;
    public int endAddress;
    public byte[] content;

    public int getLength() {
        return this.endAddress - this.startAddress + 1;
    }

    public String getCRC32() {
        CRC32 crc32 = new CRC32();
        crc32.update(this.content);
        return ByteUtility.getLongHexString(crc32.getValue());
    }

    public byte[] toByteArray(boolean forceHeader) {
        byte[] result;
        int index = 0;
        if (this.header || forceHeader) {
            result = new byte[6 + this.content.length];
            result[index++] = -1;
            result[index++] = -1;
        } else {
            result = new byte[4 + this.content.length];
        }
        result[index++] = (byte)(this.startAddress & 0xFF);
        result[index++] = (byte)(this.startAddress >>> 8);
        result[index++] = (byte)(this.endAddress & 0xFF);
        result[index++] = (byte)(this.endAddress >>> 8);
        System.arraycopy(this.content, 0, result, index, this.content.length);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ByteUtility.getWordHexString(this.startAddress));
        sb.append(" - ");
        sb.append(ByteUtility.getWordHexString(this.endAddress));
        sb.append(" CRC32=").append(this.getCRC32());
        String type = RMTFile.getType(this.content);
        if (!type.isEmpty()) {
            sb.append("\n");
            RMTFile rmtFile = new RMTFile(this.startAddress, this.endAddress, this.content);
            sb.append(rmtFile);
        }
        return sb.toString();
    }

    public boolean contentEquals(int offset, byte[] bytes) {
        if (offset >= 0 && offset + bytes.length < this.getLength()) {
            int i = 0;
            while (i < bytes.length) {
                if (this.content[offset + i] != bytes[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean contentEquals(int offset, String asciiText) {
        return this.contentEquals(offset, asciiText.getBytes(StandardCharsets.US_ASCII));
    }

    public String getContentScreenCodeString(int offset, int length) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < length) {
            int b = this.content[offset + i] & 0x7F;
            if (b <= 96) {
                b += 32;
            }
            builder.append((char)b);
            ++i;
        }
        return builder.toString();
    }

    public String getContentATATSCIIString(int offset, int length) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < length) {
            char c = (char)this.content[offset + i];
            if (c == '\u009b') {
                c = '\n';
            }
            builder.append(c);
            ++i;
        }
        return builder.toString();
    }
}

