/*
 * Decompiled with CFR 0.152.
 */
package org.atari.asma.sap;

import java.util.ArrayList;
import java.util.List;
import org.atari.asma.sap.ByteUtility;
import org.atari.asma.sap.Segment;

public class SegmentList {
    private List<Segment> entries = new ArrayList<Segment>();

    public void clear() {
        this.entries.clear();
    }

    public List<Segment> getEntries() {
        return this.entries;
    }

    public void add(Segment segment) {
        this.entries.add(segment);
    }

    public Segment get(int i) {
        return this.entries.get(i);
    }

    public int size() {
        return this.entries.size();
    }

    public byte[] toByteArray() {
        int length = 0;
        for (Segment segment : this.entries) {
            if (segment.header) {
                length += 2;
            }
            length += 4 + segment.content.length;
        }
        byte[] result = new byte[length];
        int index = 0;
        for (Segment segment : this.entries) {
            byte[] content = segment.toByteArray(false);
            System.arraycopy(content, 0, result, index, content.length);
            index += segment.content.length;
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int segmentCount = 0;
        for (Segment segment : this.entries) {
            sb.append("LOAD ");
            sb.append(ByteUtility.getByteHexString(segmentCount));
            sb.append(": ");
            sb.append(segment.toString());
            sb.append("\n");
            ++segmentCount;
        }
        return sb.toString();
    }
}

