/*
 * Decompiled with CFR 0.152.
 */
package org.atari.asma.sap.player;

import java.util.List;
import org.atari.asma.sap.ASAPFile;
import org.atari.asma.sap.Segment;
import org.atari.asma.sap.SegmentList;
import org.atari.asma.util.MessageQueue;

public abstract class Player {
    public abstract String getName();

    public abstract boolean matches(SegmentList var1);

    public void getTexts(SegmentList segmentList, List<String> texts) {
    }

    public boolean fillSAPFile(ASAPFile asapFile, SegmentList segmentList, MessageQueue messageQueue) {
        return false;
    }

    protected static boolean segmentMatches(SegmentList segmentList, int index, boolean header, int startAddress, int endAddress) {
        if (index >= segmentList.size()) {
            return false;
        }
        Segment segment = segmentList.get(index);
        if (segment.header != header) {
            return false;
        }
        if (segment.startAddress != startAddress) {
            return false;
        }
        return segment.endAddress == endAddress;
    }

    protected static void getScreenCodeTexts(Segment segment, int offset, List<String> texts) {
        int LINES = 5;
        int WIDTH = 40;
        int i = 0;
        while (i < 5) {
            texts.add(segment.getContentScreenCodeString(offset + i * 40, 40));
            ++i;
        }
    }
}

