/*
 * Decompiled with CFR 0.152.
 */
package org.atari.asma.sap.player;

import java.util.List;
import org.atari.asma.sap.ASAPFile;
import org.atari.asma.sap.ASAPFileLogic;
import org.atari.asma.sap.Segment;
import org.atari.asma.sap.SegmentList;
import org.atari.asma.sap.player.RMTPlayer;
import org.atari.asma.util.MessageQueue;

public abstract class RMT128Player
extends RMTPlayer {
    protected static final int MONO_ENDADDRESS = 14680;
    protected static final int STEREO_ENDADDRESS = 14948;
    private static final int TEXT_SEGMENT = 2;
    private static final int RMT_SEGMENT = 3;

    protected boolean matches(SegmentList segmentList, int segment0EndAddres, String magicBytes) {
        if (segmentList.size() == 5 && RMT128Player.segmentMatches(segmentList, 0, true, 12674, segment0EndAddres) && RMT128Player.segmentMatches(segmentList, 1, false, 15872, 16085) && RMT128Player.segmentMatches(segmentList, 2, false, 16128, 16329) && RMT128Player.segmentMatches(segmentList, 4, false, 736, 737)) {
            Segment segment = segmentList.get(3);
            if (!segment.header && segment.startAddress == 16384 && segment.contentEquals(0, magicBytes)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public final void getTexts(SegmentList segmentList, List<String> texts) {
        RMT128Player.getScreenCodeTexts(segmentList.get(2), 0, texts);
    }

    @Override
    public boolean fillSAPFile(ASAPFile asapFile, SegmentList segmentList, MessageQueue messageQueue) {
        ASAPFileLogic sapFileLogic = new ASAPFileLogic();
        byte[] rmtContent = segmentList.get(3).toByteArray(true);
        ASAPFile rmtFile = sapFileLogic.loadOriginalModuleFile("Converted.rmt", rmtContent, messageQueue);
        if (rmtFile == null) {
            return false;
        }
        asapFile.content = rmtFile.content;
        asapFile.setASAPInfo(rmtFile.getASAPInfo());
        return this.fillSAPFile(asapFile, segmentList, messageQueue);
    }
}

