/*
 * Decompiled with CFR 0.152.
 */
package org.atari.asma.sap.player;

import java.util.ArrayList;
import org.atari.asma.sap.ASAPFile;
import org.atari.asma.sap.SegmentList;
import org.atari.asma.sap.player.Player;
import org.atari.asma.util.MessageQueue;
import org.atari.asma.util.StringUtility;

public abstract class RMTPlayer
extends Player {
    private static String getProposedDate(String proposedTitle) {
        int secondIndex;
        int firstIndex = proposedTitle.indexOf("/");
        if (firstIndex >= 1 && (secondIndex = proposedTitle.indexOf("/", firstIndex + 1)) >= 0) {
            if (Character.isDigit(proposedTitle.charAt(--firstIndex))) {
                --firstIndex;
            }
            ++secondIndex;
            int i = 0;
            while (i < 4) {
                if (!Character.isDigit(proposedTitle.charAt(secondIndex))) break;
                ++secondIndex;
                ++i;
            }
            return proposedTitle.substring(firstIndex, secondIndex);
        }
        return "";
    }

    protected boolean fillSAPFileInternal(ASAPFile asapFile, SegmentList segmentList, MessageQueue messageQueue) {
        ArrayList<String> texts = new ArrayList<String>();
        this.getTexts(segmentList, texts);
        boolean titleComplete = false;
        StringBuilder titleBuilder = new StringBuilder();
        for (String text : texts) {
            String lower = text.toLowerCase().trim();
            if (lower.startsWith("author:")) {
                titleComplete = true;
                if (!lower.contains("press shift key") && ASAPFile.isStringEmpty(asapFile.getAuthor())) {
                    String proposedAuthor = StringUtility.condense(text.substring(7));
                    asapFile.setAuthor(proposedAuthor);
                }
            }
            if (titleComplete || lower.startsWith("MONO") || lower.startsWith("STEREO")) continue;
            titleBuilder.append(text).append(" ");
        }
        String proposedTitle = StringUtility.condense(titleBuilder.toString());
        if (ASAPFile.isStringEmpty(asapFile.getTitle())) {
            asapFile.setTitle(proposedTitle);
        }
        String proposedDate = RMTPlayer.getProposedDate(proposedTitle);
        if (ASAPFile.isStringEmpty(asapFile.getDate())) {
            asapFile.setDate(proposedDate);
        }
        return true;
    }
}

