/*
 * Decompiled with CFR 0.152.
 */
package org.atari.asma.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import org.atari.asma.util.MessageQueue;

public class BufferedMessageQueue
extends MessageQueue {
    private MessageQueue parentMessageQueue;
    private ByteArrayOutputStream outStream = new ByteArrayOutputStream();
    private ByteArrayOutputStream errStream = new ByteArrayOutputStream();

    public BufferedMessageQueue(MessageQueue parentMessageQueue) {
        this.bind(new PrintStream(this.outStream), new PrintStream(this.errStream));
        this.parentMessageQueue = parentMessageQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        MessageQueue messageQueue = this.parentMessageQueue;
        synchronized (messageQueue) {
            String err;
            String out = this.outStream.toString(StandardCharsets.UTF_8);
            if (!out.isEmpty()) {
                this.parentMessageQueue.sendInfo(out);
            }
            if (!(err = this.errStream.toString(StandardCharsets.UTF_8)).isEmpty()) {
                this.parentMessageQueue.sendError(err);
            }
        }
    }
}

