/*
 * Decompiled with CFR 0.152.
 */
package org.atari.asma.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class FileUtility {
    public static String readAsString(File file) {
        String result;
        byte[] bytes = FileUtility.readAsByteArray(file);
        try {
            result = new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return result;
    }

    public static byte[] readAsByteArray(File file) {
        try {
            return FileUtility.readAsByteArray(new FileInputStream(file));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static byte[] readAsByteArray(InputStream inputStream) {
        byte[] result;
        if (inputStream == null) {
            throw new IllegalArgumentException("Parameter 'inputStream' must not be null.");
        }
        try {
            try {
                byte[] buffer = new byte[0x1000000];
                int resultLength = FileUtility.readAndClose(inputStream, buffer);
                result = new byte[resultLength];
                System.arraycopy(buffer, 0, result, 0, resultLength);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return result;
    }

    private static final int readAndClose(InputStream inputStream, byte[] buffer) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("Parameter 'inputStream' must not be null.");
        }
        if (buffer == null) {
            throw new IllegalArgumentException("Parameter 'buffer' must not be null.");
        }
        int got = 0;
        int need = buffer.length;
        try {
            while (need > 0) {
                int i = inputStream.read(buffer, got, need);
                if (i <= 0) {
                    break;
                }
                got += i;
                need -= i;
            }
        }
        finally {
            inputStream.close();
        }
        return got;
    }

    public static List<File> getRecursiveFileList(File dir, FileFilter filter) {
        ArrayList<File> fileList = new ArrayList<File>();
        FileUtility.getRecursiveFileListInternal(dir, filter, fileList);
        return fileList;
    }

    private static void getRecursiveFileListInternal(File dir, FileFilter filter, List<File> fileList) {
        if (dir == null) {
            throw new IllegalArgumentException("Parameter dir must not be null.");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Parameter filter must not be null.");
        }
        if (fileList == null) {
            throw new IllegalArgumentException("Parameter fileList must not be null.");
        }
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                FileUtility.getRecursiveFileListInternal(f, filter, fileList);
            } else if (filter.accept(f)) {
                fileList.add(f);
            }
            ++n2;
        }
    }

    public static String getFileExtension(String fileName) {
        int index = fileName.lastIndexOf(47);
        if (index >= 0) {
            fileName = fileName.substring(index + 1);
        }
        if ((index = fileName.lastIndexOf(46)) >= 0) {
            return fileName.substring(index);
        }
        return "";
    }

    public static File changeFileExtension(File file, String extension) {
        String fileName = file.getName();
        int index = fileName.lastIndexOf(46);
        if (index >= 0) {
            fileName = fileName.substring(0, index);
        }
        fileName = String.valueOf(fileName) + extension;
        return new File(file.getParent(), fileName);
    }
}

