/*
 * Decompiled with CFR 0.152.
 */
package org.atari.asma.util;

import java.io.IOException;
import java.io.Writer;

public class JSONWriter {
    private Writer writer;

    public JSONWriter(Writer writer) {
        if (writer == null) {
            throw new IllegalArgumentException("Parameter writer must not be null.");
        }
        this.writer = writer;
    }

    private static String escapeJSON(String text) {
        text = text.replace("\"", "\\\"");
        text = text.replace("\n", "\\n");
        return text;
    }

    public void writeAttribute(String attribute) throws IOException {
        this.writer.write("\"" + attribute + "\": ");
    }

    public void writeJSONString(String attribute, String value) throws IOException {
        this.writer.write("\"" + attribute + "\": \"" + JSONWriter.escapeJSON(value) + "\"");
    }

    public void writeJSONLong(String attribute, long value) throws IOException {
        this.writer.write("\"" + attribute + "\": " + Long.toString(value));
    }

    public void beginObject() throws IOException {
        this.writer.write(123);
    }

    public void endObject() throws IOException {
        this.writer.write("}\n");
    }

    public void beginArray() throws IOException {
        this.writer.write("[\n");
    }

    public void endArray() throws IOException {
        this.writer.write("]\n");
    }

    public void writeSeparator() throws IOException {
        this.writer.write(", ");
    }
}

