/*
 * Decompiled with CFR 0.152.
 */
package org.atari.asma.util;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MessageQueue {
    private PrintStream out;
    private PrintStream err;
    private List<Entry> entries = new ArrayList<Entry>();
    private int infoCount;
    private int warningCount;
    private int errorCount;

    public MessageQueue() {
        this.clear();
    }

    public void bind(PrintStream out, PrintStream err) {
        this.out = out;
        this.err = err;
    }

    public List<Entry> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    public void addEntries(MessageQueue otherMessageQueue) {
        for (Entry entry : otherMessageQueue.getEntries()) {
            this.sendMessage(entry.type, entry.id, entry.message);
        }
    }

    public void clear() {
        this.entries.clear();
        this.infoCount = 0;
        this.warningCount = 0;
        this.errorCount = 0;
    }

    public long getInfoCount() {
        return this.infoCount;
    }

    public long getWarningCount() {
        return this.warningCount;
    }

    public long getErrorCount() {
        return this.errorCount;
    }

    public void printSummary() {
        if (this.out != null) {
            this.out.println(String.valueOf(this.errorCount) + " errors, " + this.warningCount + " warnings, " + this.infoCount + " infos");
            this.out.flush();
        }
        this.clear();
    }

    private void sendMessage(MessagType type, String id, String message) {
        this.entries.add(new Entry(type, id, message));
        switch (type) {
            case INFO: {
                if (this.out != null) {
                    this.out.println("INFO:    " + message);
                    this.out.flush();
                }
                ++this.infoCount;
                break;
            }
            case WARNING: {
                if (this.err != null) {
                    this.err.println("WARNING: " + message);
                    this.err.flush();
                }
                ++this.warningCount;
                break;
            }
            case ERROR: {
                if (this.err != null) {
                    this.err.println("ERROR:   " + message);
                    this.err.flush();
                }
                ++this.errorCount;
            }
        }
    }

    public void sendInfo(String message) {
        this.sendMessage(MessagType.INFO, "", message);
    }

    public void sendWarning(String message) {
        this.sendMessage(MessagType.WARNING, "", message);
    }

    public void sendError(String message) {
        this.sendMessage(MessagType.ERROR, "", message);
    }

    public static final class Entry {
        private MessagType type;
        private String id;
        private String message;

        public Entry(MessagType type, String id, String message) {
            this.type = type;
            this.id = id;
            this.message = message;
        }

        public MessagType getType() {
            return this.type;
        }

        public String getID() {
            return this.id;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static enum MessagType {
        INFO,
        WARNING,
        ERROR;

    }
}

