/*
 * Decompiled with CFR 0.152.
 */
package org.atari.asma.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public final class StringUtility {
    private StringUtility() {
    }

    private static String getTwoDigiNumber(long value) {
        if (value >= 10L) {
            return String.valueOf(value);
        }
        return "0" + String.valueOf(value);
    }

    public static String getDurationString(long milliseconds) {
        if (milliseconds < 0L) {
            return "";
        }
        long seconds = milliseconds / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        String durationString = String.valueOf(hours) + ":" + StringUtility.getTwoDigiNumber(minutes % 60L) + ":" + StringUtility.getTwoDigiNumber(seconds % 60L);
        return durationString;
    }

    public static String toString(Set<String> set) {
        StringBuilder result = new StringBuilder();
        Iterator<String> it = set.iterator();
        int i = 0;
        while (it.hasNext()) {
            result.append(it.next());
            if (i < set.size() - 1) {
                result.append(",");
            }
            ++i;
        }
        return result.toString();
    }

    public static String toSortedString(String[] strings) {
        TreeSet<String> set = new TreeSet<String>();
        if (strings != null) {
            String[] stringArray = strings;
            int n = strings.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                set.add(s);
                ++n2;
            }
        }
        return StringUtility.toString(set);
    }

    public static boolean hasElement(String[] array, String element) {
        if (element == null) {
            throw new IllegalArgumentException("Paramtere tag must not be null.");
        }
        if (array != null) {
            String[] stringArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s.equals(element)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static String condense(String s) {
        while (s.contains("  ")) {
            s = s.replace("  ", " ");
        }
        s = s.trim();
        return s;
    }

    public static String getToday() {
        return new SimpleDateFormat("yyyy-MM-dd").format(new Date());
    }
}

